% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fullProcess.R
\name{fullProcess}
\alias{fullProcess}
\alias{fullProcess.formula}
\title{Full process of MLGL}
\usage{
fullProcess(
  X,
  y,
  control = c("FWER", "FDR"),
  alpha = 0.05,
  test = partialFtest,
  hc = NULL,
  fractionSampleMLGL = 1/2,
  BHclust = 50,
  nCore = NULL,
  addRoot = FALSE,
  Shaffer = FALSE,
  ...
)

fullProcess.formula(
  formula,
  data,
  control = c("FWER", "FDR"),
  alpha = 0.05,
  test = partialFtest,
  hc = NULL,
  fractionSampleMLGL = 1/2,
  BHclust = 50,
  nCore = NULL,
  addRoot = FALSE,
  Shaffer = FALSE,
  ...
)
}
\arguments{
\item{X}{matrix of size n*p}

\item{y}{vector of size n.}

\item{control}{either "FDR" or "FWER"}

\item{alpha}{control level for testing procedure}

\item{test}{test used in the testing procedure. Default is \link{partialFtest}}

\item{hc}{output of \code{\link{hclust}} function. If not provided, \code{\link{hclust}} is run with ward.D2 method. User can also provide the desired method: "single", "complete", "average", "mcquitty", "ward.D", "ward.D2", "centroid", "median".}

\item{fractionSampleMLGL}{a real between 0 and 1: the fraction of individuals to use in the sample for MLGL (see Details).}

\item{BHclust}{number of replicates for computing the distance matrix for the hierarchical clustering tree}

\item{nCore}{number of cores used for distance computation. Use all cores by default.}

\item{addRoot}{If TRUE, add a common root containing all the groups}

\item{Shaffer}{If TRUE, a Shaffer correction is performed (only if control = "FWER")}

\item{...}{Others parameters for MLGL}

\item{formula}{an object of class "formula" (or one that can be coerced to that class): a symbolic description of the model to be fitted.}

\item{data}{an optional data frame, list or environment (or object coercible by as.data.frame to a data frame) containing the variables in the model. If not found in data, the variables are taken from environment(formula)}
}
\value{
a list containing:
\describe{
  \item{res}{output of \link{MLGL} function}
  \item{lambdaOpt}{lambda values maximizing the number of rejects}
  \item{var}{A vector containing the index of selected variables for the first \code{lambdaOpt} value}
  \item{group}{A vector containing the values index of selected groups for the first \code{lambdaOpt} value}
  \item{selectedGroups}{Selected groups for the first \code{lambdaOpt} value}
  \item{reject}{Selected groups for all lambda values}
  \item{alpha}{Control level}
  \item{test}{Test used in the testing procedure}
  \item{control}{"FDR" or "FWER"}
  \item{time}{Elapsed time}
}
}
\description{
Run hierarchical clustering following by a group-lasso on all the different partition and a hierarchical testing procedure. Only for linear regression problem.
}
\details{
Divide the n individuals in two samples. Then the three following steps are done:
1) Bootstrap Hierarchical Clustering of the variables of X
2) MLGL on the second sample of individuals
3) Hierarchical testing procedure on the first sample of individuals.
}
\examples{
# least square loss
set.seed(42)
X <- simuBlockGaussian(50, 12, 5, 0.7)
y <- X[, c(2, 7, 12)] \%*\% c(2, 2, -2) + rnorm(50, 0, 0.5)
res <- fullProcess(X, y)
}
\seealso{
\link{MLGL}, \link{hierarchicalFDR}, \link{hierarchicalFWER}, \link{selFDR}, \link{selFWER}
}
\author{
Quentin Grimonprez
}
