colcirc.mle <- function(x, distr = "vm", N = 2, ina, tol = 1e-07, maxiters = 100, parallel = FALSE) {
  if ( distr == "vm" ) {
    res <- Rfast::colvm.mle(x, tol = tol)
  } else if ( distr == "spml" ) {
    res <- Rfast2::colspml.mle(x, tol = tol, maxiters = maxiters, parallel = parallel)
  } else if ( distr == "purka" ) {
    res <- .colpurka.mle(x, tol = tol)
  } else if ( distr == "wrapcauchy" ) {
    res <- .colwrapcauchy.mle(x, tol = tol)
  } else if ( distr == "circexp" ) {
    res <- .colcircexp.mle(x, tol = tol)
  } else if ( distr == "circbeta" ) {
    res <- .colcircbeta.mle(x)
  } else if ( distr == "cardio" ) {
    res <- .colcardio.mle(x)
  } else if ( distr == "ggvm" ) {
    res <- .colggvm.mle(x)
  } else if ( distr == "cipc" ) {
    res <- .colcipc.mle(x, tol = tol)
  } else if ( distr == "gcpc" ) {
    res <- .colgcpc.mle(x)
  } else if ( distr == "mmvm" ) {
    res <- .colmmvm.mle(x, N = N)
  } else if ( distr == "multivm") {
    res <- .colmultivm.mle(x, ina = ina, tol = tol)
  } else if ( distr == "multispml" ) {
    res <- .colmultispml.mle(x, ina = ina, tol = tol)
  }
  res
}



.colpurka.mle <- function(x, tol) {
  res <- matrix(NA, dim(x)[2], 5)
  for ( i in 1:dim(x)[2] )  res[i, ] <- unlist( Rfast2::purka.mle(x[, i]) )
  colnames(res) <- c("theta1", "theta2", "alpha", "loglik", "alpha.sd")
  res
}

.colwrapcauchy.mle <- function(x, tol = tol) {
  res <- matrix(NA, dim(x)[2], 4)
  for ( i in 1:dim(x)[2] )  res[i, ] <- unlist( Rfast::wrapcauchy.mle(x[, i], tol = tol) )
  colnames(res) <- c("iters", "loglik", "direction", "param.rho")
  res
}

.colcircexp.mle <- function(x, tol) {
  res <- matrix(NA, dim(x)[2], 2)
  for ( i in 1:dim(x)[2] )  res[i, ] <- unlist( Directional::circexp.mle(x[, i], rads = TRUE, tol = tol) )
  colnames(res) <- c("loglik", "lambda")
  res
}

.colcircbeta.mle <- function(x) {
  res <- matrix(NA, dim(x)[2], 4)
  for ( i in 1:dim(x)[2] )  res[i, ] <- unlist( Directional::circbeta.mle(x[, i], rads = TRUE) )
  colnames(res) <- c("loglik", "mean", "alpha", "beta")
  res
}

.colcardio.mle <- function(x) {
  res <- matrix(NA, dim(x)[2], 3)
  for ( i in 1:dim(x)[2] )  res[i, ] <- unlist( Directional::cardio.mle(x[, i], rads = TRUE) )
  colnames(res) <- c("loglik", "mu", "rho")
  res
}

.colgcpc.mle <- function(x) {
  res <- matrix(NA, dim(x)[2], 6)
  for ( i in 1:dim(x)[2] )  res[i, ] <- unlist( Directional::gcpc.mle(x[, i], rads = TRUE) )
  colnames(res) <- c("mu1", "mu2", "circmu", "gamma", "rho", "loglik")
  res
}

.colmmvm.mle <- function(x, N) {
  res <- matrix(NA, dim(x)[2], 3)
  for ( i in 1:dim(x)[2] )  res[i, ] <- unlist( Directional::mmvm.mle(x[, i], N[i], rads = TRUE) )
  colnames(res) <- c("mu", "kappa", "loglik")
  res
}

.colggvm.mle <- function(x) {
  res <- matrix(NA, dim(x)[2], 5)
  for ( i in 1:dim(x)[2] )  res[i, ] <- unlist( Directional::ggvm.mle(x[, i], rads = TRUE) )
  colnames(res) <- c("loglik", "Zeta","Kappa", "mu", "alpha")
  res
}

.colcipc.mle <- function(x, tol) {
  res <- matrix(NA, dim(x)[2], 5)
  for ( i in 1:dim(x)[2] )  res[i, ] <- unlist( Directional::cipc.mle(x[, i], rads = TRUE, tol = tol) )
  colnames(res) <- c("mu1", "mu2", "circmu", "gamma", "loglik")
  res
}

.colmultivm.mle <- function(x, ina, tol) {
  res <- matrix(NA, dim(x)[2], length( unique(ina) ) * 3 )
  for ( i in 1:dim(x)[2] ) {
    a <- unlist( Rfast2::multivm.mle(x[, i], ina, tol = tol, ell = TRUE) )
    res[i, ] <- a
  }
  colnames(res) <- attributes(a)$names
  res
}

.colmultispml.mle <- function(x, ina, tol) {
  res <- matrix(NA, dim(x)[2], length( unique(ina) ) * 3 + 1)
  for ( i in 1:dim(x)[2] ) {
    a <- unlist( Rfast2::multispml.mle(x[, i], ina, tol = tol, ell = TRUE) )
    res[i, ] <- a
  }
  colnames(res) <- attributes(a)$names
  res
}
