% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper.R
\name{sampling_rate}
\alias{sampling_rate}
\title{Estimate sampling rate for multi-channel signal}
\usage{
sampling_rate(df)
}
\arguments{
\item{df}{dataframe. Input dataframe of the multi-channel signal. The first
column is the timestamps in POSXlct format and the following columns are
accelerometer values.}
}
\value{
number. The estimated sampling rate in Hz.
}
\description{
\code{sampling_rate} estimates the sampling rate based on the average time
intervals between adjacent samples for the input multi-channel signal.
}
\details{
This function accepts a dataframe of multi-channel signal, computes the
duration of the sequence, and gets the sampling rate by dividing the number
of samples by it.
}
\section{How is it used in MIMS-unit algorithm?}{
 This function is a utility
  function that was used in various part in the algorithm whenever we need to
  know the sampling rate.
}

\examples{
# Get the test data
df = sample_raw_accel_data

# Default sampling rate is 80Hz
sampling_rate(df)

# Downsample to 30Hz
output = bandlimited_interp(df, 80, 30)
sampling_rate(output)

# Upsampling to 100Hz
output = bandlimited_interp(df, 80, 100)
sampling_rate(output)
}
\seealso{
Other utility functions: 
\code{\link{clip_data}()},
\code{\link{cut_off_signal}()},
\code{\link{interpolate_signal}()},
\code{\link{parse_epoch_string}()},
\code{\link{segment_data}()},
\code{\link{simulate_new_data}()}
}
\concept{utility functions}
