% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter.R
\name{bandlimited_interp}
\alias{bandlimited_interp}
\title{Apply a bandlimited interpolation filter to the signal to change the sampling
rate}
\usage{
bandlimited_interp(df, orig_sr, new_sr)
}
\arguments{
\item{df}{dataframe. The input multi-channel signal. The first column is
timestamps in POSXlct format. The rest columns are signal values.}

\item{orig_sr}{number. Sampling rate in Hz of the input signal.}

\item{new_sr}{number. The desired sampling rate in Hz of the output signal.}
}
\value{
dataframe. Filtered signal.
}
\description{
\code{bandlimited_interp} function takes a multi-channel signal and applies a
bandlimited interpolation filter to the signal to change its sampling rate.
}
\details{
This function filters the input multi-channel signal by applying a bandlimited
interpolation filter. See \code{\link[signal]{resample}} for the underlying
implementation.
}
\section{How is it used in MIMS-unit algorithm?}{
 This function is not used in
  the released version of MIMS-unit algorithm, but has once been considered
  to be used after extrapolation to harmonize sampling rate before filtering.
  But in the end, we decided to use linear interpolation before extrapolation
  to increase the sampling rate to 100Hz, so this method is no longer needed.
}

\examples{
  # Use first 1000 rows of sample data
  df = sample_raw_accel_data[1:1000,]

  # View input
  illustrate_signal(df, plot_maxed_out_line = FALSE)

  # Apply filtering that uses the same setting as in MIMSunit algorithm
  output = bandlimited_interp(df, orig_sr=80, new_sr=30)

  # View output
  illustrate_signal(output, plot_maxed_out_line = FALSE)
}
\seealso{
Other filtering functions: 
\code{\link{bessel}()},
\code{\link{iir}()},
\code{\link{remove_average}()}
}
\concept{filtering functions}
