% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mims_unit.R
\name{sensor_orientations}
\alias{sensor_orientations}
\title{Estimates sensor orientation}
\usage{
sensor_orientations(
  df,
  before_df = NULL,
  after_df = NULL,
  epoch = "5 sec",
  dynamic_range,
  st = NULL
)
}
\arguments{
\item{df}{dataframe. Input multi-channel accelerometer signal.}

\item{before_df}{dataframe. The multi-channel accelerometer signal comes
before the input signal to be prepended to the input signal during
computation. This is used to eliminate the edge effect during extrapolation
and filtering. If it is \code{NULL}, algorithm will run directly on the
input signal. Default is NULL.}

\item{after_df}{dataframe. The multi-channel accelerometer signal comes after
the input signal to be append to the input signal. This is used to
eliminate the edge effect during extrapolation and filtering. If it is
\code{NULL}, algorithm will run directly on the input signal. Default is
NULL.}

\item{epoch}{string. Any format that is acceptable by argument \code{breaks}
in method \code{\link[base]{cut.POSIXt}}.For example, "1 sec", "1 min", "5
sec", "10 min". Default is "5 sec".}

\item{dynamic_range}{numerical vector. The dynamic ranges of the input
signal. Should be a 2-element numerical vector. \code{c(low, high)}, where
\code{low} is the negative max value the device can reach and \code{high}
is the positive max value the device can reach.}

\item{st}{character or POSIXct timestamp. An optional start time you can set to
force the epochs generated by referencing this start time. If it is NULL, the
function will use the first timestamp in the timestamp column as start time to
generate epochs. This is useful when you are processing a stream of data and
want to use a common start time for segmenting data. Default is NULL.}
}
\value{
dataframe. The orientation dataframe. The first column is the start
  time of each epoch in POSIXct format. The second to fourth columns are the
  orientation angles.
}
\description{
\code{sensor_orientations} estimates the orientation angles for the input
multi-channel accelerometer signal. The input signal can be from devices of
any sampling rate and dynamic range. Please refer to function
\code{\link{compute_orientation}} for the implementation of the estimation
algorithm.
}
\note{
This function interpolates and extrapolates the signal before
  estimating the orientation angles.

  \code{before_df} and \code{after_df} are often set when the accelerometer
  data are divided into files of smaller chunk.
}
\section{How is it used in MIMS-unit algorithm?}{
 This is not included in the
  official MIMS-unit algorithm nor the manuscript, but we found it is useful
  to know the sensor orientations in addition to the summary of movement.
}

\examples{
  # Use sample data for testing
  df = sample_raw_accel_data

  # compute sensor orientation angles
  sensor_orientations(df, epoch = '2 sec', dynamic_range=c(-8, 8))

  # compute sensor orientation angles with different epoch length
  output = sensor_orientations(df, epoch = '1 sec', dynamic_range=c(-8, 8))
  head(output)
}
\seealso{
Other Top level API functions: 
\code{\link{custom_mims_unit}()},
\code{\link{mims_unit}()},
\code{\link{shiny_app}()}
}
\concept{Top level API functions}
