% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{getMIDASScore}
\alias{getMIDASScore}
\title{Get the MIDAS score}
\usage{
getMIDASScore(
  input,
  rows = 2L,
  buckets = 769L,
  alpha = 0.6,
  norelations = FALSE,
  undirected = FALSE
)
}
\arguments{
\item{input}{A data.frame with columns src (source, int), dst (destination, int) & times (timestamp of the edge, int) representing transaction edges}

\item{rows}{Number of rows/hash functions. Default is 2}

\item{buckets}{Number of buckets. Default is 769}

\item{alpha}{Temporal Decay Factor. Only used when 'MIDAS-R' is used. Default is 0.6}

\item{norelations}{Run 'MIDAS' instead of 'MIDAS-R'. Default is False}

\item{undirected}{If graph is undirected. Default is False}
}
\value{
NumericVector of MIDAS-Scores
}
\description{
Get the MIDAS score
}
