% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CreateFas_func_20170924.R
\name{CreateFas}
\alias{CreateFas}
\title{CreateFas() function}
\usage{
CreateFas(seq_table, path_out)
}
\arguments{
\item{seq_table}{seq_table is a sequence table as output by the 'dada2'
pipeline, which has samples in rows and nucleotide sequence variants in
columns.}

\item{path_out}{is a user defined path to the folder where the output files
will be saved.}
}
\value{
A FASTA file with all the sequences in a 'dada2' sequence table. The
  sequences are named in the FASTA file by an index number corresponding to
  their column number in the sequence table.
}
\description{
\code{\link{CreateFas}} creates a FASTA file with all the sequences in a
'dada2' sequence table.
}
\details{
If you publish data or results produced with MHCtools, please cite both of
the following references:
Roved, J. 2022. MHCtools: Analysis of MHC data in non-model species. Cran.
Roved, J., Hansson, B., Stervander, M., Hasselquist, D., & Westerdahl, H. 2022.
MHCtools - an R package for MHC high-throughput sequencing data: genotyping,
haplotype and supertype inference, and downstream genetic analyses in non-model
organisms. Molecular Ecology Resources. https://doi.org/10.1111/1755-0998.13645
}
\examples{
seq_table <- sequence_table_fas
path_out <- tempdir()
CreateFas(seq_table, path_out)
}
\seealso{
\code{\link{CreateSamplesFas}}; for more information about 'dada2'
  visit <https://benjjneb.github.io/dada2/>
}
