% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PN-matrix.R
\name{spn_S}
\alias{spn_S}
\title{Make stoichiometry Matrix For a Petri Net}
\usage{
spn_S(spn_P, spn_T)
}
\arguments{
\item{spn_P}{set of places (P) (see details)}

\item{spn_T}{set of transitions (T) (see details)}
}
\value{
stoichiometry matrix representing the net effect of a transition in the SPN state model.
}
\description{
Generate the stoichiometry (|u| by |v|) matrix for the SPN.
Each column gives the net effect of that transition firing upon the state
space of the model. Internally, this creates a Pre (\code{\link{spn_Pre}}) and
Post (\code{\link{spn_Post}}) matrix, and then calculates the final stoichiometry.
}
\details{
The places (\code{spn_P}) object is generated from one of the following:
\code{\link{spn_P_lifecycle_node}}, \code{\link{spn_P_lifecycle_network}},
\code{\link{spn_P_epiSIS_node}}, \code{\link{spn_P_epiSIS_network}},
\code{\link{spn_P_epiSEIR_node}}, or \code{\link{spn_P_epiSEIR_network}}.

The set of transitions (\code{spn_T}) is generated from one of the following:
\code{\link{spn_T_lifecycle_node}}, \code{\link{spn_T_lifecycle_network}},
\code{\link{spn_T_epiSIS_node}}, \code{\link{spn_T_epiSIS_network}},
\code{\link{spn_T_epiSEIR_node}}, \code{\link{spn_T_epiSEIR_network}}.
}
