% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PN-epiSEIR-network-P.R
\name{spn_P_epiSEIR_network}
\alias{spn_P_epiSEIR_network}
\title{Make Places (P) For a Network (SEI Mosquitoes - SEIR Humans)}
\usage{
spn_P_epiSEIR_network(node_list, params, cube)
}
\arguments{
\item{node_list}{a character vector specifying what type of nodes to create;
(m = a node with only mosquitoes, h = a node with only humans, b = a node with both humans and mosquitoes)}

\item{params}{a named list of parameters (see details)}

\item{cube}{an inheritance cube from the \code{MGDrivE} package (e.g. \code{\link[MGDrivE]{cubeMendelian}})}
}
\value{
a list with two elements: \code{ix} contains labeled indices of the places
by life stage and node, \code{u} is the character vector of places (P)
}
\description{
This function makes the set of places (P) for a SPN model of a metapopulation
network for simulation of coupled SEI-SEIR dynamics. It is the network version
of \code{\link{spn_P_epiSEIR_node}}.
}
\details{
The \code{params} argument supplies all of the ecological parameters necessary
to calculate equilibrium values. This function requires the \code{nE},
\code{nL}, \code{nP}, and \code{nEIP} parameters to be specified. For more details, see
\code{\link{equilibrium_SEI_SEIR}}

For examples of using this function, see:
\code{vignette("seir-dynamics", package = "MGDrivE2")}
}
