% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MECfda_simDataGen_ME.R
\name{MECfda_simDataGen_ME}
\alias{MECfda_simDataGen_ME}
\title{Simulation Data Generation: Measurement Error Bias Correction of Scalar-on-function Regression}
\usage{
MECfda_simDataGen_ME(
  N = 100,
  J_W = 7,
  forwhich = c("MEM", "IV", "CLS", "IV.SIMEX"),
  t_interval = c(0, 1),
  n_t = 24,
  seed = 0
)
}
\arguments{
\item{N}{Sample size.}

\item{J_W}{Number of repeated measurement (period), if applicable.}

\item{forwhich}{For which method of measurement error bias correction method
the data set is generated.
There are two options: 'MEM','IV','CLS','IV.SIMEX'.}

\item{t_interval}{A 2-element vector, represents an interval,
means the domain of the functional covariate.
Default is \code{c(0,1)}, represent interval \eqn{[0,1]}.}

\item{n_t}{Number of measurement time points.}

\item{seed}{Pseudo-random number generation seed.}
}
\value{
return a list that possibly contains following elements.
   \item{Y}{An atomic vector of response variable}
   \item{Z}{A dataframe with a binary and a continuous scalar-valued covariate.}
   \item{W}{Observed values of function-valued covariate.}
   \item{M}{Instrumental vairable.}
   \item{t_interval}{Same as in the input argument.}
   \item{t_points}{Sequence of the measurement (time) points.}
}
\description{
Generate data set for measurement error bias correction methods
for scalar-on-function regression in package MECfda
}
\examples{
for (i in 1:4) {MECfda_simDataGen_ME(forwhich = c('MEM','IV','CLS','IV.SIMEX')[i])}
}
