% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classDefintions.R
\docType{class}
\name{Fourier_series-class}
\alias{Fourier_series-class}
\alias{Fourier_series}
\title{s4 class of Fourier summation series}
\description{
A s4 class that represents the linear combination of Fourier basis functions below:
\deqn{\frac{a_0}{2} +
\sum_{k=1}^{p_a} a_k \cos{(\frac{2\pi}{T}k(x-t_0))} +
\sum_{k=1}^{p_b} b_k \sin{(\frac{2\pi}{T}k(x-t_0))},
\qquad x\in[t_0,t_0+T]}
}
\details{
If not assigned, \eqn{t_0 = 0}, \eqn{T = 2\pi}.
If not assigned, k_cos and k_sin equals 1, 2, 3, ...
}
\section{Slots}{

\describe{
\item{\code{double_constant}}{value of \eqn{a_0}.}

\item{\code{cos}}{values of coefficients of \eqn{\cos} waves, \eqn{a_k}.}

\item{\code{sin}}{values of coefficients of \eqn{\sin} waves, \eqn{b_k}.}

\item{\code{k_cos}}{values of \eqn{k} corresponding to the coefficients of \eqn{\cos} waves}

\item{\code{k_sin}}{values of \eqn{k} corresponding to the coefficients of \eqn{\sin} waves}

\item{\code{t_0}}{left end of the domain interval, \eqn{t_0}}

\item{\code{period}}{length of the domain interval, \eqn{T}.}
}}

\examples{
fsc = Fourier_series(
           double_constant = 0.5,
           cos = c(0,0.3),
           sin = c(1,0.7),
           k_cos = 1:2,
           )
}
\author{
Heyang Ji
}
