% (C) 2015 Christian Margreitter
% last update: 2017-02-21
\name{xrmsd}
\alias{xrmsd}
\title{XRMSD plot in heatmap style}
\description{Plots an heatmap according to the RMSD values for a 2D snapshot matrix, based on molecular dynamics trajectories.}
\usage{
xrmsd( xrmsdValues,
       printLegend = TRUE,
       xaxisRange = NA,
       yaxisRange = NA,
       colours = NA,
       rmsdUnit = "nm",
       barePlot = FALSE,
       ... )}
\arguments{
  \item{xrmsdValues}{Input matrix (three rows: x-values, y-values, RMSD-value). Can be generated by function \code{\link{load_xrmsd}()}.}
  \item{printLegend}{If \code{TRUE}, a legend is printed on the right hand side of the plot.}
  \item{xaxisRange}{A vector of boundaries for the x-snapshots.}
  \item{yaxisRange}{A vector of boundaries for the y-snapshots.}
  \item{colours}{A vector with colour names for the span palette.}
  \item{rmsdUnit}{Specifies, in which unit the RMSD values are given.}
  \item{barePlot}{Boolean, indicating whether the plot is to be made without any additional information.}
  \item{...}{Additional arguments (ellipsis).}
}
\value{
This function does not return data.
}
\examples{
# GROMOS (see load_xrmsd() for other input possibilities)
xrmsd( load_xrmsd( system.file( "extdata/xrmsd_example.txt.gz",
                                package = "MDplot" ),
                   factor = 10000 ) )
}
\author{Christian Margreitter}
\keyword{xrmsd}