% (C) 2015 Christian Margreitter
% last update: 2017-02-20
\name{dssp_ts}
\alias{dssp_ts}
\title{DSSP timeseries plot for secondary structure elements (proteins)}
\description{
Plots time-series for secondary structure motifs in the context of the widely used DSSP algorithm. The default order is: "3-Helix", "4-Helix", "5-Helix", "Bend", "Beta-Bridge", "Beta-Strand", "Turn".}
\usage{
dssp_ts( tsData,
         printLegend = TRUE,
         timeBoundaries = NA,
         residueBoundaries = NA,
         timeUnit = NA,
         snapshotsPerTimeInt = 1000,
         barScaleFactor = 0.25,
         barePlot = FALSE,
         ... )}
\arguments{
  \item{tsData}{List consisting of lists, which are composed of a \code{name} (string) and a \code{values} table (x ... snapshots, y ... residues). Can be generated by \code{\link{load_dssp_ts}()}.}
  \item{printLegend}{If \code{TRUE}, a legend is printed on the right hand side of the plot.}
  \item{timeBoundaries}{A vector of boundaries for the time in snapshots.}
  \item{residueBoundaries}{A vector of boundaries for the residues.}
  \item{timeUnit}{If set, the snapshots are transformed into the respective time (depending on parameter \code{snapshotsPerTime}.}
  \item{snapshotsPerTimeInt}{Number of snapshots per respective \code{timeUnit} (only used when \code{timeUnit} is set).}
  \item{barScaleFactor}{Allows to manually overwrite the height of the bars.}
  \item{barePlot}{Boolean, indicating whether the plot is to be made without any additional information.}
  \item{...}{Additional arguments (ellipsis).}
}
\value{
This function does not return data.
}
\examples{
# GROMOS (see load_dssp_ts() for other input possibilities)
dssp_ts( load_dssp_ts( system.file( "extdata/dssp_ts_example",
                                    package = "MDplot" ) ) )
}
\author{Christian Margreitter}
\keyword{dssp}
