% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MDEI.R
\name{MDEI}
\alias{MDEI}
\title{MDEI function}
\usage{
MDEI(
  y,
  treat,
  X,
  splits = 10,
  alpha = 0.9,
  samplesplit = TRUE,
  conformal = TRUE,
  nthreads.ranger = NULL,
  verbose = TRUE
)
}
\arguments{
\item{y}{The outcome variable, a vector.}

\item{treat}{The treatment variable, a vector.}

\item{X}{A matrix of covariates.}

\item{splits}{Number of repeated cross-fitting steps to implement.}

\item{alpha}{The desired level of the confidence band.}

\item{samplesplit}{Whether to use a sample splitting approach. Default is \code{TRUE}.}

\item{conformal}{Whether to generate a conformal bands or use a critical value from the
normal approximation.  Default is \code{TRUE}..}

\item{nthreads.ranger}{Number of threads used internally by the \code{ranger} function 
for random forests.  Default is \code{NULL}.}

\item{verbose}{An optional logical value. If \code{TRUE} information 
on the number of split samples completed is printed. Default is \code{TRUE}.}
}
\value{
\describe{
\item{tau.est}{The estimated marginal effect.}
\item{CIs.tau}{Upper and lower values of conformal confidence band.}
\item{critical.values}{Conformal critical values.}
\item{Ey.x}{Mean of outcome given only covariates.}
\item{coefficients}{The list of all nonparametric bases and the proportion of sample splits that they were selected.}
\item{internal}{Internal objects used for development and diagnostics.}
}
}
\description{
Implements the Method of Direct Estimation and Inference
}
\examples{
n <- 100

X <- matrix(rnorm(n*1), nrow = n)
treat <- rnorm(n)
y <- treat^2 + X[,1] + rnorm(n)

# Be sure to run with more splits than this.  We recommend
# at least 10-50 initially, for exploratory analyses, with several hundred for 
# publication quality. For large sample sizes, these numbers may be adjusted down.
# These are only recommendations.
# Threads are set to 1 to pass CRAN checks, but we suggest leaving it at the default
# which ranger takse as the total number available.
set.seed(1)
m1 <- MDEI(y, treat, X, splits=1, alpha=.9, nthreads.ranger = 1)

# Accuracy
cor(m1$tau.est, treat*2)
cor(m1$theta.est, treat^2)

# Coverage
mean(apply(m1$CIs.tau-2*treat,1,prod)<0)
}
\references{
Ratkovic, Marc and Dustin Tingley.  2023. "Estimation and Inference on Nonlinear and Heterogeneous Effects."  The Journal of Politics.
}
