% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_optimal_coef.R
\name{find_optimal_coef}
\alias{find_optimal_coef}
\title{Find Adaptive Boxplot Coefficient `coef` via Grid Search}
\usage{
find_optimal_coef(
  contin_table,
  n_sim = 1000,
  target_fdr = 0.05,
  grid = 0.1,
  col_specific_cutoff = TRUE,
  exclude_small_count = TRUE
)
}
\arguments{
\item{contin_table}{A matrix representing the \eqn{I \times J}
contingency table.}

\item{n_sim}{An integer specifying the number of simulated tables under
the assumption of independence between rows and columns. Default is 1000.}

\item{target_fdr}{A numeric value specifying the desired level of false
discovery rate (FDR). Default is 0.05.}

\item{grid}{A numeric value representing the size of the grid added to
the default value of \code{coef = 1.5} as suggested by Tukey. Default is 0.1.}

\item{col_specific_cutoff}{Logical. If TRUE, then a single value of the
coefficient is returned for the entire dataset, else when FALSE specific
values corresponding to each of the columns are returned.}

\item{exclude_small_count}{A logical indicating whether to exclude cells
with counts smaller than or equal to five when computing boxplot statistics.
Default is \code{TRUE}.}
}
\value{
A list with the following components:
\describe{
 \code{coef}: A numeric vector containing the optimal coefficient
             `coef` for each column of the input contingency table.

 \code{FDR}: A numeric vector with the corresponding false discovery
             rate (FDR) for each column.
}
}
\description{
This function performs a grid search to determine the optimal
adaptive boxplot coefficient `coef` for each column of a contingency
table, ensuring the target false discovery rate (FDR) is met.
}
\examples{
\donttest{
# This example uses the statin49 data
data(statin49)
find_optimal_coef(statin49)
}
}
