% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PDF_3dPlot.R
\name{PDF_3dPlot}
\alias{PDF_3dPlot}
\title{3D plot of the joint PDF of the bivariate exponential distribution (BED) based on the Moran-Downton model}
\usage{
PDF_3dPlot(
  rho,
  Betax,
  Betay,
  xlabel = "x",
  ylabel = "y",
  zlabel = "Joint PDF",
  title = "BED",
  angle = -35,
  GS = 0.5
)
}
\arguments{
\item{rho}{Correlation coefficient between the marginals distributions of and y.}

\item{Betax}{Scale parameter of the marginal distribution of x.}

\item{Betay}{Scale parameter of the marginal distribution of y.}

\item{xlabel}{Label of the x-axis.}

\item{ylabel}{Label of the y-axis.}

\item{zlabel}{Label of the z-axis.}

\item{title}{Title of the figure.}

\item{angle}{Angle of the 3D projection.}

\item{GS}{Grid spacing; value between 0 and 1 (Default value 0.5)}
}
\value{
A 3D plot of the joint PDF of the BED is provided.
}
\description{
This function builds a 3D plot of the joint PDF of the BED. The required inputs are the correlation
coefficient and the scale parameters of the marginal distributions. This function also allows several
characteristics of the plot to be set.
}
\details{
Based on the function \code{\link[graphics]{persp}} of the \code{\link{graphics}} package.
}
\examples{
PDF_3dPlot(rho=0.85,Betax=1,Betay=1)
}
\author{
Luis F. Duque <lfduquey@gmail.com> <l.f.duque-yaguache2@newcastle.ac.uk>
}
