% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CDF_3dPlot.R
\name{CDF_3dPlot}
\alias{CDF_3dPlot}
\title{3D plot of the joint CDF of the bivariate exponential distribution (BED) based on the Moran-Downton model}
\usage{
CDF_3dPlot(
  rho,
  Betax,
  Betay,
  xlabel = "x",
  ylabel = "y",
  zlabel = "Joint CDF",
  title = "BED",
  angle = 45,
  GS = 0.5
)
}
\arguments{
\item{rho}{Correlation coefficient between marginal distributions of x and y.}

\item{Betax}{Scale parameter of the marginal distribution of x.}

\item{Betay}{Scale parameter of the marginal distribution of y.}

\item{xlabel}{Label of the x-axis.}

\item{ylabel}{Label of the y-axis.}

\item{zlabel}{Label of the z-axis.}

\item{title}{Title of the figure.}

\item{angle}{Angle of the 3D projection (Default value 45).}

\item{GS}{Grid spacing; value between 0 and 1 (Default value 0.5).}
}
\value{
A 3D plot of the joint CDF of the BED is provided.
}
\description{
This function builds a 3D plot of the joint CDF of the BED.
The required inputs are the correlation coefficient and the scale parameters of the marginal distributions. This
function also allows several characteristics of the plot to be set.
}
\details{
Based on the function \code{\link[lattice]{wireframe}} of the \code{\link{lattice}} package.
}
\examples{
\donttest{CDF_3dPlot(rho=0.85,Betax=1,Betay=1)}
}
\author{
Luis F. Duque <lfduquey@gmail.com> <l.f.duque-yaguache2@newcastle.ac.uk>
}
