% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/WASPAS.R
\name{WASPAS}
\alias{WASPAS}
\title{Implementation of WASPAS Method for Multi-Criteria Decision Making Problems.}
\usage{
WASPAS(decision, weights, cb, lambda)
}
\arguments{
\item{decision}{The decision matrix (\emph{m} x \emph{n}) with the values of the \emph{m} alternatives, for the \emph{n} criteria.}

\item{weights}{A vector of length \emph{n}, containing the weights for the criteria. The sum of the weights has to be 1.}

\item{cb}{A vector of length \emph{n}. Each component is either \code{cb(i)='max'} if the \emph{i-th} criterion is benefit or \code{cb(i)='min'} if the \emph{i-th} criterion is a cost.}

\item{lambda}{A value in [0,1]. It is used in the calculation of the W index.}
}
\value{
\code{WASPAS} returns a data frame which contains the score of the W index and the ranking of the alternatives.
}
\description{
The \code{WASPAS} function implements the Weighted Aggregated Sum Product ASsessment (WASPAS) Method.
}
\examples{
d <- matrix(rpois(12, 5), nrow = 4)
 w <- c(0.2, 0.2, 0.6)
 cb <- c('max','min','max')
 lambda <- 0.5
 WASPAS(d,w,cb,lambda)
}
\references{
Zavadskas, E. K.; Turskis, Z.; Antucheviciene, J.; Zakarevicius, A. Optimization of Weighted Aggregated Sum Product Assessment. Electronics and Electrical Engineering, 122(6), 3-6, 2012.
}

