% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/M.R
\name{M}
\alias{M}
\title{Computes an inconsistency index for sequences of means.}
\usage{
M(mu_S, patterns)
}
\arguments{
\item{mu_S}{The sequence of means \eqn{\mu_\mathbb{S}}.}

\item{patterns}{A vector with all the patterns in \eqn{\mathbb{S}}.}
}
\value{
The value of \eqn{M()}, in the interval \eqn{[0,1]}.
}
\description{
A function that computes the inconsistency index \eqn{M(\mu_\mathbb{S})} for a sequence of
means, as defined in Section 5 in \insertCite{BB2024;textual}{MCARtest}.
}
\examples{
library(MASS)

d = 3
n = 200
SigmaS=list() #Random 2x2 correlation matrices (necessarily consistent)
for(j in 1:d){
x=runif(2,min=-1,max=1); y=runif(2,min=-1,max=1); SigmaS[[j]]=cov2cor(x\%*\%t(x) + y\%*\%t(y))
}

X = data.frame(matrix(nrow = 3*n, ncol = 3))
X[1:n, c(1,2)] = mvrnorm(n, c(0,0), SigmaS[[1]])
X[(n+1):(2*n), c(2, 3)] = mvrnorm(n, c(0,0), SigmaS[[2]])
X[(2*n+1):(3*n), c(1, 3)] = mvrnorm(n, c(0,0), SigmaS[[3]])
X = as.matrix(X)

xxx = get_SigmaS(X)$patterns
M(get_SigmaS(X)$muS, xxx)
}
\references{
\insertRef{BB2024}{MCARtest}
}
