% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepare.functions.R
\name{mbnma.comparisons}
\alias{mbnma.comparisons}
\title{Identify unique comparisons within a network}
\usage{
mbnma.comparisons(df)
}
\arguments{
\item{df}{A data frame containing variables \code{studyID} and \code{treatment} (as numeric codes) that
indicate which treatments are used in which studies.}
}
\value{
A data frame of unique comparisons in which each row represents a different comparison.
\code{t1} and \code{t2} indicate the treatment codes that make up the comparison. \code{nr} indicates the number
of times the given comparison is made within the network.

If there is only a single follow-up observation for each study within the dataset (i.e. as for standard
network meta-analysis) \code{nr} will represent the number of studies that compare treatments \code{t1} and
\code{t2}.

If there are multiple observations for each study within the dataset (as in time-course MBNMA)
\code{nr} will represent the number of time points in the dataset in which treatments \code{t1} and \code{t2} are
compared.
}
\description{
Identify unique contrasts within a network that make up all the head-to-head comparisons. Repetitions
of the same treatment comparison are grouped together.
}
\examples{
df <- data.frame(studyID=c(1,1,2,2,3,3,4,4,5,5,5),
  treatment=c(1,2,1,3,2,3,3,4,1,2,4)
  )

# Identify unique comparisons within the data
mbnma.comparisons(df)


# Using the triptans headache dataset
network <- mbnma.network(triptans) # Adds treatment identifiers
mbnma.comparisons(network$data.ab)

}
