% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepare.functions.R
\name{recode.agent}
\alias{recode.agent}
\title{Assigns agent or class variables numeric identifiers}
\usage{
recode.agent(data.ab, level = "agent")
}
\arguments{
\item{data.ab}{A data frame of arm-level data in "long" format containing the columns:
\itemize{
\item \code{studyID} Study identifiers
\item \code{dose} Numeric data indicating the dose (must take positive values)
\item \code{agent} Agent identifiers (can be numeric, factor or character)
\item \code{y} Numeric data indicating the aggregate response for a continuous outcome. Required for
continuous data.
\item \code{se} Numeric data indicating the standard error for a given observation. Required for
continuous data.
\item \code{r} Numeric data indicating the number of responders within a study arm. Required for
binomial or poisson data.
\item \code{n} Numeric data indicating the total number of participants within a study arm. Required for
binomial data or when modelling Standardised Mean Differences
\item \code{E} Numeric data indicating the total exposure time for participants within a study arm. Required
for poisson data.
\item \code{class} An optional column indicating a particular class code. Agents with the same identifier
must also have the same class code.
}}

\item{level}{Can take either \code{"agent"} or \code{"class"}}
}
\value{
A list containing a data frame with recoded agent/class identifiers and
a character vector of original agent/class names
}
\description{
Assigns agent or class variables numeric identifiers
}
\details{
Also relabels the agent for any arms in which dose = 0 to "Placebo_0"
}
