% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run.functions.R
\name{mbnma.linear}
\alias{mbnma.linear}
\title{Run MBNMA model with a linear dose-response function (DEPRECATED)}
\usage{
mbnma.linear(
  network,
  slope = "rel",
  method = "common",
  class.effect = list(),
  UME = FALSE,
  cor = TRUE,
  omega = NULL,
  parameters.to.save = NULL,
  pd = "pd.kl",
  likelihood = NULL,
  link = NULL,
  priors = NULL,
  arg.params = NULL,
  ...
)
}
\arguments{
\item{network}{An object of class \code{mbnma.network}.}

\item{slope}{Refers to the slope parameter of the linear dose-response function.
Can take either \code{"rel"}, \code{"common"}, \code{"random"}, or be assigned a numeric value (see details in \code{?mbnma.run}).}

\item{method}{Can take either \code{"common"} or \code{"random"} to indicate whether relative effects
should be modelled with between-study heterogeneity or not (see details).}

\item{class.effect}{A list of named strings that determines which dose-response
parameters to model with a class effect and what that effect should be
(\code{"common"} or \code{"random"}). Element names should match dose-response parameter names.
Note that assuming class effects on some dose-response parameters may be unreasonable if
the range of doses differ substantially across agents within a class.}

\item{UME}{A boolean object to indicate whether to fit an Unrelated Mean Effects model
that does not assume consistency and so can be used to test if the consistency
assumption is valid.}

\item{cor}{A boolean object that indicates whether correlation should be modelled
between relative effect dose-response parameters. This is
automatically set to \code{FALSE} if class effects are modelled or if multiple dose-response
functions are fitted.}

\item{omega}{A scale matrix for the inverse-Wishart prior for the covariance matrix used
to model the correlation between dose-response parameters (see Details for dose-response functions). \code{omega} must
be a symmetric positive definite matrix with dimensions equal to the number of dose-response parameters modelled using
relative effects (\code{"rel"}). If left as \code{NULL} (the default) a diagonal matrix with elements equal to 1
is used.}

\item{parameters.to.save}{A character vector containing names of parameters
to monitor in JAGS}

\item{pd}{Can take either:
\itemize{
\item \code{pv} only pV will be reported (as automatically outputted by \code{R2jags}).
\item \code{plugin} calculates pD by the plug-in
method \insertCite{spiegelhalter2002}{MBNMAdose}. It is faster, but may output negative
non-sensical values, due to skewed deviances that can arise with non-linear models.
\item \code{pd.kl} calculates pD by the Kullback-Leibler divergence \insertCite{plummer2008}{MBNMAdose}. This
will require running the model for additional iterations but is a more robust calculation for the effective
number of parameters in non-linear models.
\item \code{popt} calculates pD using an optimism adjustment which allows for calculation
of the penalized expected deviance \insertCite{plummer2008}{MBNMAdose}.
}}

\item{likelihood}{A string indicating the likelihood to use in the model. Can take either \code{"binomial"},
\code{"normal"} or \code{"poisson"}. If left as \code{NULL} the likelihood will be inferred from the data.}

\item{link}{A string indicating the link function to use in the model. Can take any link function
defined within JAGS (e.g. \code{"logit"}, \code{"log"}, \code{"probit"}, \code{"cloglog"}), be assigned the value \code{"identity"} for
an identity link function, or be assigned the value \code{"smd"} for modelling Standardised Mean Differences using an
identity link function. If left as \code{NULL} the link function will be automatically assigned based
on the likelihood.}

\item{priors}{A named list of parameter values (without indices) and
replacement prior distribution values given as strings
\strong{using distributions as specified in JAGS syntax} (see \insertCite{jagsmanual;textual}{MBNMAdose}).}

\item{arg.params}{Assign run and wrapper parameters}

\item{...}{Arguments to be sent to R2jags.}
}
\value{
An object of S3 \code{class(c("mbnma", "rjags"))} containing parameter
results from the model. Can be summarized by \code{print()} and can check
traceplots using \code{R2jags::traceplot()} or various functions from the package \code{mcmcplots}.

Nodes that are automatically monitored (if present in the model) have the
following interpretation:\tabular{ll}{
   \strong{Parameters(s)/Parameter Prefix} \tab \strong{Interpretation} \cr
   \verb{<named dose-response parameter>} (e.g. \code{emax}) \tab The pooled effect for each dose-response parameter, as defined in dose-response functions. Will vary by agent if pooling is specified as \code{"rel"} in the dose-response function. \cr
   \code{sd} \tab The between-study SD (heterogeneity) for relative effects, reported if \code{method="random"} \cr
   \verb{sd.<named dose-response parameter>} (e.g. \code{sd.emax}) \tab Between-study SD (heterogeneity) for absolute dose-response parameters specified as \code{"random"}. \cr
   \verb{<named capitalized dose-response parameter>} (e.g. \code{EMAX}) \tab The class effect within each class for a given dose-response parameter. These will be estimated by the model if specified in \code{class.effects} for a given dose-response parameter. \cr
   \verb{sd.<named capitalized dose-response parameter>} (e.g. \code{sd.EMAX}) \tab The within-class SD for different agents within the same class. Will be estimated by the model if any dose-response parameter in \code{class.effect} is set to \code{"random"}. \cr
   \code{totresdev} \tab The residual deviance of the model \cr
   \code{deviance} \tab The deviance of the model \cr
}


If there are errors in the JAGS model code then the object will be a list
consisting of two elements - an error message from JAGS that can help with
debugging and \code{model.arg}, a list of arguments provided to \code{mbnma.run()}
which includes \code{jagscode}, the JAGS code for the model that can help
users identify the source of the error.
}
\description{
FUNCTION IS NOW DEPRECATED - USE \code{mbnma.run()} DIRECTLY WITH OBJECTS OF \code{class("dosefun")}
}
\details{
Fits a Bayesian model-based network meta-analysis (MBNMA) with a defined
dose-response function. Follows the methods
of \insertCite{mawdsley2016;textual}{MBNMAdose}. This function acts as a wrapper for \code{mbnma.run()} that
uses more clearly defined parameter names.
}
\section{Dose-response parameter arguments}{
\tabular{ll}{
   \strong{Argument} \tab \strong{Model specification} \cr
   \code{"rel"} \tab Implies that \emph{relative} effects should be pooled for this dose-response parameter separately for each agent in the network. \cr
   \code{"common"} \tab Implies that all agents share the same common effect for this dose-response parameter. \cr
   \code{"random"} \tab Implies that all agents share a similar (exchangeable) effect for this dose-response parameter. This approach allows for modelling of variability between agents. \cr
   \code{numeric()} \tab Assigned a numeric value, indicating that this dose-response parameter should not be estimated from the data but should be assigned the numeric value determined by the user. This can be useful for fixing specific dose-response parameters (e.g. Hill parameters in Emax functions) to a single value. \cr
}
}

\examples{
\donttest{
# Using the triptans data
tripnet <- mbnma.network(triptans)

# Fit a linear dose-response MBNMA with random treatment effects
linear <- mbnma.linear(tripnet, slope="rel", method="random")

# For further examples see ?mbnma.run
}

}
\references{
\insertAllCited
}
