% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RandomForestModel.r
\name{RandomForestModel}
\alias{RandomForestModel}
\title{Random forest model}
\arguments{
\item{SplitRatio}{Train and test split ratio. A value greater or equal to zero and less than one.}

\item{CV}{The number of folds for cross-validation. It should be greater than one.}

\item{NTree}{The number of trees to be grown.}

\item{NCores}{The number of cores for parallel computing.}

\item{NewData}{A methylation data from ReadMethylFile function.}
}
\value{
A list
}
\description{
A function to train a random forest model to classify medulloblastoma subgroups using the DNA methylation dataset (Illumina Infinium HumanMethylation450). Prediction is followed by training if new data is provided.
}
\examples{
set.seed(21)
rf <- RandomForestModel(SplitRatio = 0.8,
                        CV = 3,
                        NTree = 10,
                        NCores = 1,
                        NewData = NULL)
}
