% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MAVE_DIR.R
\name{mave.dir}
\alias{mave.dir}
\title{Directions of CS or CMS of given dimension}
\usage{
mave.dir(dr, dim = NULL)
}
\arguments{
\item{dr}{the output of \code{\link{mave}} or the output of \code{\link{mave.dim}}}

\item{dim}{the dimension of CS or CMS. The value of dim should be given when the class of the
argument dr is mave. When the class of the argument dr is mave.dim and dim is not given, the
function will return the basis matrix of CS or CMS of dimension selected by \code{\link{mave.dim}}}
}
\value{
dir the matrix of CS or CMS of given dimension
}
\description{
This function returns the basis matrix of CS or CMS of given dimension
}
\examples{
x <- matrix(rnorm(400),100,4)
y <- x[,1]+x[,2]+as.matrix(rnorm(100))
dr <- mave(y~x)
dir3 <- mave.dir(dr,3)

dr.dim <- mave.dim(dr)
dir3 <- mave.dir(dr.dim,3)
dir.best <- mave.dir(dr.dim)

}

