% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MARX_functions.R
\name{marx.t}
\alias{marx.t}
\title{The estimation of the MARX model by t-MLE function}
\usage{
marx.t(y, x, p_C, p_NC, params0)
}
\arguments{
\item{y}{Data vector of time series observations.}

\item{x}{Matrix of data (every column represents one time series). Specify NULL or "not" if not wanted.}

\item{p_C}{Number of lags.}

\item{p_NC}{Number of leads.}

\item{params0}{Starting values for the parameters to be estimated (both model and distributional parameters).}
}
\value{
\item{coef.c}{Estimated causal coefficients.}

\item{coef.nc}{Estimated noncausal coefficients.}

\item{coef.exo}{Estimated exogenous coefficients.}

\item{coef.int}{Estimated intercept.}

\item{scale}{Estimated scale parameter.}

\item{df}{Estimated degrees of freedom.}

\item{residuals}{Residuals.}
}
\description{
This function allows you to estimate the MARX model by t-MLE.
}
\examples{
data <- sim.marx(c('t',3,0),c('t',3,1),100,0.5,0.4,0.3)
marx.t(data$y,data$x,1,1)
}
\author{
Sean Telg
}
\keyword{causal-noncausal}
\keyword{estimation}

