% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Script_01_4_ComputePSI_A3SS.R
\name{ComputePSI.A3SS}
\alias{ComputePSI.A3SS}
\title{Compute Alternative 3' Splice Site (A3SS) Percent Spliced-in (PSI) Values}
\usage{
ComputePSI.A3SS(MarvelObject, CoverageThreshold)
}
\arguments{
\item{MarvelObject}{S3 object generated from \code{CreateMarvelObject} function.}

\item{CoverageThreshold}{Numeric value. Coverage threshold below which the PSI of the splicing event will be censored, i.e. annotated as missing (NA). Coverage defined as the total number of reads supporting both included and excluded isoforms.}
}
\value{
An object of class S3 containing all the original slots as inputted by the user in addition to two new slots. \code{$SpliceFeatureValidated$A3SS} contains the validated splicing event metadata. \code{$PSI$A3SS} contains the computed PSI values for the validated splicing events.
}
\description{
\code{ComputePSI.A3SS} computes percent spliced-in (PSI) Alternative 3' splice site (A3SS) splicing event.
}
\details{
This function computes the PSI for each A3SS splicing event. Splicing events provided in \code{SpliceFeature} data frame will first be cross-checked against the splice junctions provided in \code{SpliceJunction} data frame. Only events whose junctions are found in \code{SpliceJunction} are retained. The formula for computing PSI is the number of junction reads supporting the included isoform divided by the total number of reads supporting both included and excluded isoforms.
}
\examples{
marvel <- readRDS(system.file("extdata/Data", "MarvelObject.rds", package="MARVEL"))

marvel <- ComputePSI.A3SS(MarvelObject=marvel,
                          CoverageThreshold=10
                          )

marvel$SpliceFeatureValidated$A3SS
marvel$PSI$A3SS[,1:5]
}
\author{
Sean Wen <sean.wenwx@gmail.com>
}
