% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MANOVA_simCI.R
\name{simCI}
\alias{simCI}
\title{Multivariate post-hoc comparisons and simultaneous confidence intervals for contrasts in multivariate factorial designs}
\usage{
simCI(object, contrast, contmat = NULL, type = NULL, base = 1,
  interaction = TRUE, factor = NA, silent = FALSE, ...)
}
\arguments{
\item{object}{A \code{MANOVA} object.}

\item{contrast}{The contrast matrix of interest, can either be "pairwise" or "user-defined".}

\item{contmat}{If contrast = "user-defined", the contrast matrix must be specified here. Note that
its rows must sum to zero.}

\item{type}{If contrast is "pairwise", the type of the pairwise comparison must be specified here. 
Calculation is based on the contrMat function in package multcomp, see the corresponding help page 
for details on the types of contrasts available.}

\item{base}{An integer specifying which group is considered the baseline group 
for Dunnett contrasts, see \code{\link[multcomp]{contrMat}}.}

\item{interaction}{Logical. If interaction = FALSE in models with more than one factor, the factor of interest for 
the post-hoc analysis must be specified. Default is TRUE, which means post-hoc tests are performed for all factor
level combinations.}

\item{factor}{Only needed if interaction = FALSE. Specifies the factor for which post-hoc analysis are requested.}

\item{silent}{Set to TRUE to suppress output.}

\item{...}{Not used yet.}
}
\value{
Multivariate p-values and simultaneous confidence intervals for the chosen contrasts.
}
\description{
Multivariate post-hoc comparisons and simultaneous confidence intervals for contrasts in multivariate factorial designs
}
\details{
The simCI() function computes the multivariate p-values for the chosen contrast of the multivariate mean vector 
based on the bootstrap version of the sum statistic. Details on this test can be found in Friedrich and Pauly (2018).
Furthermore, confidence intervals for summary effects (i.e., averaged over each dimension), also based on the bootstrap
version of the sum statistic, are returned as well.
}
\references{
Friedrich, S., and Pauly, M. (2018). MATS: Inference for potentially singular and
  heteroscedastic MANOVA. Journal of Multivariate Analysis, 165, 166-179.
}
\seealso{
\code{\link[multcomp]{contrMat}}
}
