% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MCL_tuning.R
\name{MCL_tuning}
\alias{MCL_tuning}
\title{MCL Hyperparameters Tuning}
\usage{
MCL_tuning(hc_ppi, predcpx, refcpx, inflation = c(6, 8, 9), csize = 2)
}
\arguments{
\item{hc_ppi}{Interactions data containing id1-id2-weight triplets.}

\item{predcpx}{A data.frame containing predicted modules resulted from
\code{\link[MACP]{get_clusters}}.}

\item{refcpx}{A list containing reference complexes
(i.e., corum complexes).}

\item{inflation}{A vector of integer, representing
MCL inflation parameter}

\item{csize}{An integer, the minimum size of the predicted complexes.
Defaults to 2.}
}
\value{
A data.frame containing clustering performance across different
inflation values.
}
\description{
This function optimize the choice of MCL algorithm
parameter (inflation) by comparing clustering-derived partitions for each
paramter values to known labels (i.e., CORUM complexes) and
assess the similarity between them using quality measures including
overlap score, sensitivity (Sn),
clustering-wise positive predictive value (PPV), geometric accuracy (Acc),
and maximum matching raio (MMR). It is recommended to first reduce
redundancy in the known reference complexes
via \code{\link{EliminateCpxRedundance}}, then performs parameter tuning.
}
\details{
MCL_tuning
}
\author{
Matineh Rahmatbakhsh, \email{matinerb.94@gmail.com}
}
