% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MCL_clustering.R
\name{MCL_clustering}
\alias{MCL_clustering}
\title{MCL clustering}
\usage{
MCL_clustering(hc_ppi, predcpx, inflation = 9, csize = 2)
}
\arguments{
\item{hc_ppi}{High-confidence interactions data containing
id1-id2-weight triplets.}

\item{predcpx}{A data.frame containing predicted complexes resulted from
\code{\link[MACP]{get_clusters}}.}

\item{inflation}{MCL inflation parameter. Defaults to 9.}

\item{csize}{An integer, the minimum size of the predicted complexes.
Defaults to 2.}
}
\value{
List of refined complexes.
}
\description{
This function applies MCL clustering to further refine
the predicted subnetworks produced by ClusterONE.
}
\details{
MCL_clustering
}
\examples{
# open high-confidence network
hc_ppi <-
read.delim(
system.file("extdata/ppi_input_ClusterONE.txt", package = "MACP"),
header = FALSE)
# predict complexes by ClusterONE
predcpx <-
get_clusters(csize = 3, d = 0.3, p = 2,
max_overlap = 0.8,
tpath = file.path(system.file("extdata", package = "MACP")))
# Break down big complexes by MCL
MCL_clusters <- MCL_clustering(hc_ppi, predcpx, inflation = 4, csize = 2)
}
\author{
Matineh Rahmatbakhsh
}
