/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.rhul.cs.cl1.ui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.BorderFactory;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.JTextArea;
import javax.swing.JToolTip;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicToolTipUI;
import uk.ac.rhul.cs.cl1.ui.JMultiLineToolTip;

class MultiLineToolTipUI
extends BasicToolTipUI {
    static MultiLineToolTipUI instance = new MultiLineToolTipUI();
    Border tooltipBorder = new CompoundBorder(BorderFactory.createLineBorder(Color.BLACK, 1), BorderFactory.createEmptyBorder(2, 2, 2, 2));
    JToolTip tip;
    protected CellRendererPane rendererPane;
    private static JTextArea textArea;

    MultiLineToolTipUI() {
    }

    public static ComponentUI createUI(JComponent c) {
        return instance;
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        this.tip = (JToolTip)c;
        this.rendererPane = new CellRendererPane();
        c.add(this.rendererPane);
    }

    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        c.remove(this.rendererPane);
        this.rendererPane = null;
    }

    public void paint(Graphics g, JComponent c) {
        Dimension size = c.getSize();
        textArea.setBackground(c.getBackground());
        this.rendererPane.paintComponent(g, textArea, c, 0, 0, size.width, size.height, true);
    }

    public Dimension getPreferredSize(JComponent c) {
        String tipText = ((JToolTip)c).getTipText();
        JMultiLineToolTip comp = (JMultiLineToolTip)c;
        Dimension dim = null;
        if (tipText == null) {
            return new Dimension(0, 0);
        }
        textArea = new JTextArea(tipText);
        textArea.setBorder(this.tooltipBorder);
        this.rendererPane.removeAll();
        this.rendererPane.add(textArea);
        textArea.setWrapStyleWord(true);
        int width = comp.getFixedWidth();
        if (width > 0) {
            textArea.setLineWrap(true);
            dim = textArea.getPreferredSize();
            dim.width = width;
            ++dim.height;
            textArea.setSize(dim);
        } else {
            textArea.setLineWrap(false);
        }
        dim = textArea.getPreferredSize();
        ++dim.height;
        ++dim.width;
        return dim;
    }

    public Dimension getMinimumSize(JComponent c) {
        return this.getPreferredSize(c);
    }

    public Dimension getMaximumSize(JComponent c) {
        return this.getPreferredSize(c);
    }
}

