/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.rhul.cs.cl1.seeding;

import com.sosnoski.util.hashmap.StringIntHashMap;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.StringTokenizer;
import java.util.TreeSet;
import uk.ac.rhul.cs.cl1.MutableNodeSet;
import uk.ac.rhul.cs.cl1.seeding.SeedGenerator;
import uk.ac.rhul.cs.cl1.seeding.SeedIterator;
import uk.ac.rhul.cs.graph.Graph;

public class FileBasedSeedGenerator
extends SeedGenerator {
    private String filename;
    private int size;
    private boolean generateUnusedNodesAsSeeds = false;
    private boolean disconnectedSeedsIgnored = true;

    public FileBasedSeedGenerator(Graph graph, String filename) throws FileNotFoundException, IOException {
        super(graph);
        this.filename = filename;
        File f = new File(this.filename);
        LineNumberReader reader = new LineNumberReader(new FileReader(f));
        String nextLine = null;
        while ((nextLine = reader.readLine()) != null) {
            if (!"*".equals(nextLine)) continue;
            this.generateUnusedNodesAsSeeds = true;
        }
        this.size = reader.getLineNumber();
        reader.close();
    }

    public boolean areDisconnectedSeedsIgnored() {
        return this.disconnectedSeedsIgnored;
    }

    public SeedIterator iterator() {
        return new IteratorImpl(this.filename);
    }

    public void setDisconnectedSeedsIgnored(boolean disconnectedSeedsIgnored) {
        this.disconnectedSeedsIgnored = disconnectedSeedsIgnored;
    }

    public int size() {
        if (this.generateUnusedNodesAsSeeds) {
            return this.graph.getNodeCount();
        }
        return this.size;
    }

    private class IteratorImpl
    extends SeedIterator {
        BufferedReader reader = null;
        String line = null;
        MutableNodeSet currentNodeSet = null;
        StringIntHashMap namesToIndices = new StringIntHashMap();
        TreeSet<Integer> unusedNodes = new TreeSet();

        public IteratorImpl(String filename) {
            File f = new File(filename);
            int n = FileBasedSeedGenerator.this.graph.getNodeCount();
            for (int i = 0; i < n; ++i) {
                this.namesToIndices.add(FileBasedSeedGenerator.this.graph.getNodeName(i), i);
                this.unusedNodes.add(i);
            }
            try {
                this.reader = new BufferedReader(new FileReader(f));
            }
            catch (FileNotFoundException ex) {
                ex.printStackTrace();
                return;
            }
            this.readNextLine();
            this.processLine();
        }

        private void readNextLine() {
            try {
                this.line = this.reader.readLine();
            }
            catch (IOException ex) {
                ex.printStackTrace();
                this.line = null;
            }
        }

        private void processLine() {
            this.currentNodeSet = new MutableNodeSet(FileBasedSeedGenerator.this.graph);
            if (this.line == null) {
                if (FileBasedSeedGenerator.this.generateUnusedNodesAsSeeds) {
                    Integer id = this.unusedNodes.pollFirst();
                    if (id == null) {
                        this.currentNodeSet = null;
                    } else {
                        this.currentNodeSet.add(id);
                    }
                } else {
                    this.currentNodeSet = null;
                }
                return;
            }
            boolean isConnected = false;
            while (!isConnected) {
                StringTokenizer st = new StringTokenizer(this.line);
                while (st.hasMoreTokens()) {
                    String name = st.nextToken();
                    int idx = this.namesToIndices.get(name);
                    if (idx < 0) continue;
                    this.currentNodeSet.add(idx);
                    this.unusedNodes.remove(idx);
                }
                this.readNextLine();
                isConnected = this.currentNodeSet.size() > 0 && this.currentNodeSet.isConnected();
                if (isConnected) continue;
                this.currentNodeSet.clear();
                if (this.line != null) continue;
                if (FileBasedSeedGenerator.this.generateUnusedNodesAsSeeds) {
                    Integer id = this.unusedNodes.pollFirst();
                    this.currentNodeSet.add(id);
                } else {
                    this.currentNodeSet = null;
                }
                return;
            }
            if (isConnected) {
                return;
            }
            this.currentNodeSet = null;
        }

        public boolean hasNext() {
            return this.currentNodeSet != null;
        }

        public MutableNodeSet next() {
            MutableNodeSet result = this.currentNodeSet;
            this.processLine();
            return result;
        }
    }
}

