% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analyse_Al2O3C_CrossTalk.R
\name{analyse_Al2O3C_CrossTalk}
\alias{analyse_Al2O3C_CrossTalk}
\title{Al2O3:C Reader Cross Talk Analysis}
\usage{
analyse_Al2O3C_CrossTalk(object, signal_integral = NULL, dose_points = c(0,
  4), recordType = c("OSL (UVVIS)"), irradiation_time_correction = NULL,
  method_control = NULL, plot = TRUE, ...)
}
\arguments{
\item{object}{\linkS4class{RLum.Analysis} \strong{(required)}:
measurement input}

\item{signal_integral}{\link{numeric} (\emph{optional}):
signal integral, used for the signal and the background.
If nothing is provided the full range is used}

\item{dose_points}{\link{numeric} (\emph{with default}):
vector with dose points, if dose points are repeated, only the general
pattern needs to be provided. Default values follow the suggestions
made by Kreutzer et al., 2017}

\item{recordType}{\link{character} (\emph{with default}): input curve selection, which is passed to
function \link{get_RLum}. To deactivate the automatic selection set the argument to \code{NULL}}

\item{irradiation_time_correction}{\link{numeric} or \linkS4class{RLum.Results} (\emph{optional}):
information on the used irradiation time correction obained by another experiements.}

\item{method_control}{\link{list} (\emph{optional}):
optional parameters to control the calculation.
See details for further explanations}

\item{plot}{\link{logical} (\emph{with default}):
enable/disable plot output}

\item{...}{further arguments that can be passed to the plot output}
}
\value{
Function returns results numerically and graphically:

-----------------------------------\cr
\code{[ NUMERICAL OUTPUT ]}\cr
-----------------------------------\cr

\strong{\code{RLum.Results}}-object

\strong{slot:} \strong{\code{@data}}

\tabular{lll}{
\strong{Element} \tab \strong{Type} \tab \strong{Description}\cr
\code{$data} \tab \code{data.frame} \tab summed apparent dose table \cr
\code{$data_full} \tab \code{data.frame} \tab full apparent dose table \cr
\code{$fit} \tab \code{lm} \tab the linear model obtained from fitting \cr
\code{$col.seq} \tab \code{numeric} \tab the used colour vector \cr
}

\strong{slot:} \strong{\code{@info}}

The original function call

------------------------\cr
\code{[ PLOT OUTPUT ]}\cr
------------------------\cr
\itemize{
\item An overview of the obtained apparent dose values
}
}
\description{
The function provides the analysis of cross-talk measurements on a
FI lexsyg SMART reader using Al2O3:C pellets
}
\section{Function version}{
 0.1.2 (2018-03-09 14:49:07)
}

\examples{

##load data
data(ExampleData.Al2O3C, envir = environment())

##run analysis
analyse_Al2O3C_CrossTalk(data_CrossTalk)

} 

\section{How to cite}{
Kreutzer, S. (2018). analyse_Al2O3C_CrossTalk(): Al2O3:C Reader Cross Talk Analysis. Function version 0.1.2. In: Kreutzer, S., Burow, C., Dietze, M., Fuchs, M.C., Schmidt, C., Fischer, M., Friedrich, J. (2018). Luminescence: Comprehensive Luminescence Dating Data Analysis. R package version 0.8.2. https://CRAN.R-project.org/package=Luminescence
}

\references{
Kreutzer, S., Martin, L., Guérin, G., Tribolo, C., Selva, P., Mercier, N., in press. Environmental Dose Rate
Determination Using a Passive Dosimeter: Techniques and Workflow for alpha-Al2O3:C Chips.
Geochromometria 45, 56-67. doi: 10.1515/geochr-2015-0086
}
\seealso{
\link{analyse_Al2O3C_ITC}
}
\author{
Sebastian Kreutzer, IRAMAT-CRP2A, Universite Bordeaux Montaigne (France)
\cr R Luminescence Package Team}
\keyword{datagen}
