% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PLR-ineqExplained.R
\name{ineqExplained.PLR}
\alias{ineqExplained.PLR}
\alias{ineqExplained.PLR_boot}
\alias{ineqExplained.PLR_cv}
\title{Explained inequality metrics for the penalized Lorenz regression}
\usage{
\method{ineqExplained}{PLR}(
  object,
  type = c("Gini.explained", "Lorenz-R2"),
  pars.idx = "BIC",
  ...
)
}
\arguments{
\item{object}{An object of S3 class \code{"PLR"}. The object might also have S3 classes \code{"PLR_boot"} and/or \code{"PLR_cv"} (both inherit from class \code{"PLR"})}

\item{type}{Character string specifying the type of inequality metric to retrieve. Options are \code{"Gini.explained"} (for the explained Gini coefficient) and \code{"Lorenz-R2"} (for the Lorenz-\eqn{R^2}).}

\item{pars.idx}{What grid and penalty parameters should be used for parameter selection. Either a character string specifying the selection method, where the possible values are:
\itemize{
   \item \code{"BIC"} (default) - Always available.
   \item \code{"Boot"} - Available if \code{object} inherits from \code{"PLR_boot"}.
   \item \code{"CV"} - Available if \code{object} inherits from \code{"PLR_cv"}.
}
Or a numeric vector of length 2, where the first element is the index of the grid parameter and the second is the index of the penalty parameter.}

\item{...}{Additional arguments.}
}
\value{
A numeric value representing the requested inequality metric.
}
\description{
Retrieves the explained Gini coefficient or the Lorenz-\eqn{R^2} from an object of class \code{"PLR"}.
}
