% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Lorenz-bootstrap-combine.R
\name{Lorenz.boot.combine}
\alias{Lorenz.boot.combine}
\title{Combines bootstrap Lorenz regressions}
\usage{
Lorenz.boot.combine(boot_list)
}
\arguments{
\item{boot_list}{list of objects, each element being the output of a call to the function \code{\link{Lorenz.boot}}.}
}
\value{
An object of class \code{c("LR_boot", "LR")} or \code{c("PLR_boot", "PLR")}, depending on whether a non-penalized or penalized regression was fitted.

The method \code{confint} is used on an object of class \code{"LR_boot"} or \code{"PLR_boot"} to obtain bootstrap inference on the model parameters.

For the non-penalized Lorenz regression, the returned object is a list containing the following components:
\describe{
   \item{\code{theta}}{The estimated vector of parameters. In the penalized case, it is a matrix where each row corresponds to a different selection method (e.g., BIC, bootstrap, cross-validation).}
   \item{\code{Gi.expl}}{The estimated explained Gini coefficient. In the penalized case, it is a vector, where each element corresponds to a different selection method.}
   \item{\code{LR2}}{The Lorenz-\eqn{R^2} of the regression. In the penalized case, it is a vector, where each element corresponds to a different selection method.}
   \item{\code{boot_out}}{An object of class \code{"boot"} containing the output of the bootstrap calculation.}
}
For the penalized Lorenz regression, the returned object is a list containing the following components:
\describe{
   \item{\code{path}}{See \code{\link{Lorenz.Reg}} for the original path. To this path is added the out-of-bag (OOB) score.}
   \item{\code{lambda.idx}}{A vector indicating the index of the optimal lambda obtained by each selection method.}
   \item{\code{grid.idx}}{A vector indicating the index of the optimal grid parameter obtained by each selection method.}
}
Note: The returned object may have additional classes such as \code{"PLR_cv"} if cross-validation was performed and used as a selection method in the penalized case.
}
\description{
\code{Lorenz.boot.combine} combine outputs of different instances of the \code{\link{Lorenz.boot}} function.
}
\section{References}{

Heuchenne, C. and A. Jacquemain (2022). Inference for monotone single-index conditional means: A Lorenz regression approach. \emph{Computational Statistics & Data Analysis 167(C)}.

Jacquemain, A., C. Heuchenne, and E. Pircalabelu (2024). A penalised bootstrap estimation procedure for the explained Gini coefficient. \emph{Electronic Journal of Statistics 18(1) 247-300}.
}

\examples{
\dontshow{
utils::example(Lorenz.Reg, echo = FALSE)
}
# Continuing the Lorenz.Reg(.) example for the penalized regression:
boot_list <- list()
set.seed(123)
boot_list[[1]] <- Lorenz.boot(PLR, R = 15, data.orig = data, boot_out_only = TRUE)
set.seed(456)
boot_list[[2]] <- Lorenz.boot(PLR, R = 15, data.orig = data, boot_out_only = TRUE)
PLR_boot <- Lorenz.boot.combine(boot_list)
summary(PLR_boot)

}
\seealso{
\code{\link{Lorenz.boot}}
}
