% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fBM.R
\name{fBM}
\alias{fBM}
\title{Fractional Brownian Motion / Bridge of Type I or II.}
\usage{
fBM(n, d, type = c("I", "II"), bridge = FALSE)
}
\arguments{
\item{n}{number of increments in the fractional Brownian motion.}

\item{d}{memory parameter -0.5<d<0.5. Note that \code{d=H-1/2}.}

\item{type}{either \code{"I"} or \code{"II"}, to define the type of motion.}

\item{bridge}{either \code{TRUE} of \code{FALSE}, to specify whether ar fractional
Brownian motion or bridge should be returned. Default is \code{FALSE} so that the function
returns a fractional Brownian motion.}
}
\description{
\code{fBM} simulates a fractional Brownian motion / bridge of type I or II.
}
\examples{
n<-1000
d<-0.4
set.seed(1234)
motionI<-fBM(n,d, type="I")
set.seed(1234)
motionII<-fBM(n,d, type="II")
ts.plot(motionI, ylim=c(min(c(motionI,motionII)), max(motionI,motionII)))
lines(motionII, col=2)
}
\references{
Marinucci, D., Robinson, P. M. (1999). Alternative forms of fractional Brownian motion. 
Journal of statistical planning and inference, 80(1-2), 111 - 122.

Davidson, J., Hashimzade, N. (2009). Type I and type II fractional Brownian motions: A reconsideration. 
Computational statistics & data analysis, 53(6), 2089-2106. 

Bardet, J.-M. et al. (2003): Generators of long-range dependent processes: a survey. 
Theory and applications of long-range dependence, pp. 579 - 623, Birkhauser Boston.
}
\author{
Kai Wenger
}
