% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ARRLS_sim.R
\name{ARRLS.sim}
\alias{ARRLS.sim}
\title{Simulation of Autoregressive Random Level Shift processes.}
\usage{
ARRLS.sim(T, phi, sig.shifts, prob, sig.noise = 0, const = 0,
  trend = 0, burnin = 100)
}
\arguments{
\item{T}{length of the desired series.}

\item{phi}{autoregressive parameter that determines the persistence of the shifts.
For \code{phi=1} the process is a "stationary RLS" and for \code{phi=0} the process
is a non stationary RLS.}

\item{sig.shifts}{standard deviation of the shifts.}

\item{prob}{shift probability. For rare shifts p*/T, where p* is the expected number of shifts in the sample.}

\item{sig.noise}{standard deviation of the noise component. Default is \code{sig.noise=0}.}

\item{const}{mean of the process. Default is \code{const=0}.}

\item{trend}{trend of the process. Default is \code{trend=0}.}

\item{burnin}{length of the burnin period used. Default is \code{burnin=100}.}
}
\description{
Simulation of a AR-RLS process as discussed in and Xu and Perron (2014).
}
\details{
add details here
}
\examples{
ts.plot(ARRLS.sim(T=500,phi=0.5, sig.shift=1, prob=0.05), ylab=expression(X[t]))
}
\references{
Xu, J. and Perron, P. (2014): Forecasting return volatility: Level shifts with 
             varying jump probability and mean reversion. International Journal of Forecasting,
             30, pp. 449-463.
}
\author{
Christian Leschinski
}
