% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Logistic.R
\name{Logistic}
\alias{Logistic}
\title{logistic—function to perform logistic analysis and return the results to the user.}
\usage{
Logistic(
  data,
  colnum,
  numresamples,
  remove_VIF_greater_than,
  remove_data_correlations_greater_than,
  remove_ensemble_correlations_greater_than,
  save_all_trained_models = c("Y", "N"),
  save_all_plots = c("Y", "N"),
  set_seed = c("Y", "N"),
  how_to_handle_strings = c(0("none"), 1("factor levels"), 2("One-hot encoding"),
    3("One-hot encoding with jitter")),
  do_you_have_new_data = c("Y", "N"),
  stratified_column_number,
  use_parallel = c("Y", "N"),
  train_amount,
  test_amount,
  validation_amount
)
}
\arguments{
\item{data}{data can be a CSV file or within an R package, such as MASS::Pima.te}

\item{colnum}{the column number with the logistic data}

\item{numresamples}{the number of resamples}

\item{remove_VIF_greater_than}{Removes features with VIGF value above the given amount (default = 5.00)}

\item{remove_data_correlations_greater_than}{Enter a number to remove correlations in the initial data set (such as 0.98)}

\item{remove_ensemble_correlations_greater_than}{Enter a number to remove correlations in the ensembles}

\item{save_all_trained_models}{"Y" or "N". Places all the trained models in the Environment}

\item{save_all_plots}{Options to save all plots}

\item{set_seed}{Asks the user to set a seed to create reproducible results}

\item{how_to_handle_strings}{0: No strings, 1: Factor values}

\item{do_you_have_new_data}{"Y" or "N". If "Y", then you will be asked for the new data}

\item{stratified_column_number}{0 if no stratified random sampling, or column number for stratified random sampling}

\item{use_parallel}{"Y" or "N" for parallel processing}

\item{train_amount}{set the amount for the training data}

\item{test_amount}{set the amount for the testing data}

\item{validation_amount}{Set the amount for the validation data}
}
\value{
a real number
}
\description{
logistic—function to perform logistic analysis and return the results to the user.
}
