## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup--------------------------------------------------------------------
library(LogicForest)
library(data.table)
library(LogicReg)

## -----------------------------------------------------------------------------

load(system.file("data", "LF.data.rda", package="LogicForest"))
data(LF.data)

#Set using annealing parameters using the logreg.anneal.control 
#function from LogicReg package

newanneal<-logreg.anneal.control(start=1, end=-2, iter=2500)

#typically more than 2500 iterations (iter>25000) would be used for 
#the annealing algorithm.  A typical forest also contains at 
#least 100 trees.  These parameters were set to allow for faster
#run times

#The data set LF.data contains 50 binary predictors and a binary
#response Ybin
LF.fit1<-logforest(resp=LF.data$Ybin, Xs=LF.data[,1:50], nBS=20, anneal.params=newanneal)
print(LF.fit1)
predict(LF.fit1)

#Changing print parameters
LF.fit2<-logforest(resp=LF.data$Ybin, Xs=LF.data[,1:50], nBS=20,
anneal.params=newanneal, norm=TRUE, numout=10)
print(LF.fit2)

