% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/additionalFunctions.R
\name{getInclusionList}
\alias{getInclusionList}
\title{Obtain an inclusion list from the annotation results}
\usage{
getInclusionList(results, adductsTable = LipidMS::adductsTable)
}
\arguments{
\item{results}{data frame. Output of identification functions.}

\item{adductsTable}{data frame with the adducts allowed and their mass
difference.}
}
\value{
Data frame with 6 columns: formula, RT, neutral mass, m/z, adduct
and the compound name.
}
\description{
Obtain an inclusion list from the annotation results.
}
\examples{
\dontrun{
devtools::install_github("maialba3/LipidMSdata2")

library(LipidMS)
msobject <- idPOS(LipidMSdata2::msobjectDIApos)
getInclusionList(msobject)
}

}
\author{
M Isabel Alcoriza-Balaguer <maribel_alcoriza@iislafe.es>
}
