% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EXTPLindley.R
\name{EXTPLindley}
\alias{EXTPLindley}
\alias{dextplindley}
\alias{hextplindley}
\alias{pextplindley}
\alias{qextplindley}
\alias{rextplindley}
\title{Extended Power Lindley Distribution}
\source{
[dpqh]extplindley are calculated directly from the definitions. \code{rextplindley} uses either a two-component mixture of gamma distributions or the inverse transform method.
}
\usage{
dextplindley(x, theta, alpha, beta, log = FALSE)

pextplindley(q, theta, alpha, beta, lower.tail = TRUE, log.p = FALSE)

qextplindley(p, theta, alpha, beta, lower.tail = TRUE, log.p = FALSE)

rextplindley(n, theta, alpha, beta, mixture = TRUE)

hextplindley(x, theta, alpha, beta, log = FALSE)
}
\arguments{
\item{x, q}{vector of positive quantiles.}

\item{theta, alpha, beta}{positive parameters.}

\item{log, log.p}{logical. If TRUE, probabilities p are given as log(p).}

\item{lower.tail}{logical. If TRUE (default) \eqn{P(X \leq x)} are returned, otherwise \eqn{P(X > x)}.}

\item{p}{vector of probabilities.}

\item{n}{number of observations. If \code{length(n) > 1}, the length is taken to be the number required.}

\item{mixture}{logical. If TRUE (default), random values are generated from a two-component mixture of gamma distributions, otherwise from the quantile function.}
}
\value{
\code{dextplindley} gives the density, \code{pextplindley} gives the distribution function, \code{qextplindley} gives the quantile function, \code{rextplindley} generates random deviates and \code{hextplindley} gives the hazard rate function.

Invalid arguments will return an error message.
}
\description{
Density function, distribution function, quantile function, random numbers generation and hazard rate function for the extended power Lindley distribution with parameters theta, alpha and beta.
}
\details{
Probability density function
\deqn{f(x\mid \theta,\alpha,\beta )={\frac{\alpha \theta ^{2}}{\theta +\beta }}(1+\beta x^{\alpha })\ x^{\alpha -1}\ e^{-\theta x^{\alpha }}}

Cumulative distribution function
\deqn{F(x\mid \theta,\alpha,\beta )=1-\left( 1+{\frac{\beta \theta x^{\alpha }}{\theta +\beta }}\right) \ e^{-\theta x^{\alpha }}}

Quantile function
\deqn{Q(p\mid \theta ,\alpha ,\beta )={\left[ -\frac{1}{\theta }-\frac{1}{\beta }-{\frac{1}{\theta }}W_{-1}{\left( {\frac{\left( p-1\right) \left( \beta +\theta \right) }{\beta }}e{{^{-{\frac{\beta +\theta }{\beta }}}}}\right) }\right] }^{\frac{1}{\alpha }}}

Hazard rate function
\deqn{h(x\mid \theta ,\alpha ,\beta )={\frac{\alpha {\theta }^{2}\left( 1+\beta {x}^{\alpha }\right) {x}^{\alpha -1}}{\left( \beta +\theta \right) {\left(1+{\frac{\beta \theta {x}^{\alpha }}{\beta +\theta }}\right) }}}}

where \eqn{W_{-1}} denotes the negative branch of the Lambert W function.

\bold{Particular cases:} \eqn{\beta = 1} the power Lindley distribution, \eqn{\alpha = 1} the two-parameter Lindley distribution and \eqn{(\alpha = 1, \beta = 1)} the one-parameter Lindley distribution.
}
\examples{
set.seed(1)
x <- rextplindley(n = 1000, theta = 1.5, alpha = 1.5, beta = 1.5, mixture = TRUE)
R <- range(x)
S <- seq(from = R[1], to = R[2], by = 0.1)
plot(S, dextplindley(S, theta = 1.5, alpha = 1.5, beta = 1.5), xlab = 'x', ylab = 'pdf')
hist(x, prob = TRUE, main = '', add = TRUE)

p <- seq(from = 0.1, to = 0.9, by = 0.1)
q <- quantile(x, prob = p)
pextplindley(q, theta = 1.5, alpha = 1.5, beta = 1.5, lower.tail = TRUE)
pextplindley(q, theta = 1.5, alpha = 1.5, beta = 1.5, lower.tail = FALSE)
qextplindley(p, theta = 1.5, alpha = 1.5, beta = 1.5, lower.tail = TRUE)
qextplindley(p, theta = 1.5, alpha = 1.5, beta = 1.5, lower.tail = FALSE)

library(fitdistrplus)
fit <- fitdist(x, 'extplindley', start = list(theta = 1.5, alpha = 1.5, beta = 1.5))
plot(fit)

}
\author{
Josmar Mazucheli \email{jmazucheli@gmail.com}

Larissa B. Fernandes \email{lbf.estatistica@gmail.com}
}
\references{
Alkarni, S. H., (2015). Extended power Lindley distribution: A new statistical model for non-monotone survival data. \emph{European Journal of Statistics and Probability}, \bold{3}, (3), 19-34.
}
\seealso{
\code{\link[LambertW]{W}}.
}

