% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/InsuranceParameters.R
\docType{data}
\name{InsuranceContract.ParameterDefaults}
\alias{InsuranceContract.ParameterDefaults}
\title{Default parameters for the InsuranceContract class. A new contract will be
pre-filled with these values, and values passed in the constructor (or with
other setter functions) will override these values.}
\format{
The parameter list is a list of lists with the following structure:

Sublists:
\itemize{
\item \code{$ContractData} ... Contract-specific data (policy period,
closing, age, sum insured, premium payments, etc.)
\item \code{$ContractState} ... Current contract state (paid-up, surrender
penalty already applied, alpha costs already (partially) refunded)
\item \code{$ActuarialBases} ... Actuarial bases for the contract
calculation (mortality/invalidity table, guaranteed interest,
surrender penalty, etc.)
\item \code{$Costs} ... Expenses charged to the contract (see \code{\link[=initializeCosts]{initializeCosts()}})
\item \code{$Loadings} ... Loadings, rebates and other charges of the
tariff / contract (tax, unit costs, surcharge for no medial exam, premium/benefit frequency loading)
\item \code{$Features} ... Peculiarities of the tariff (to enable
non-standard formulas for certain company-specific historical
"glitches" in the tariff definitions.)
\item \code{$ProfitParticipation} ... Profit scheme and profit participation
rates (default values, can be overwritten per profit scenario)
\item \code{$Hooks} ... Hook functions to allow modification of various
calculation aspects (e.g. modify the default cash flows after
their setup)
}
\subsection{Elements of sublist \code{InsuranceContract.ParameterDefault$ContractData}}{

These values are typically set per contract and not by the tariff. Notable
exceptions are the contract duration in some instances and the premiumPeriod=1
for single-premium contracts.

\describe{
\item{\code{$id}}{ID of the contract (to distinguish individual parts in
contracts with multiple parts, e.g. dynamic increases),
default = "Hauptvertrag"}
\item{\code{$sumInsured}}{Sum insured, default = 100,000}
\item{\code{$YOB}}{Year of birth of the insured, used to determine the
age for the application of the mortality table}
\item{\code{$age}}{Age of the insured}
\item{\code{$technicalAge}}{Technical age of the insured (when the age
for the application of the mortality table does not coincide
with the real age)}
\item{\code{$ageDifferences}}{Vector of age differences to the first
insured for contracts with multiple insured (i.e. joint-lives)}
\item{\code{$sex}}{Sex of the insured, to allow gender-specific prixing
(e.g. different mortalities or age modification), default="unisex",
Type is \link{SexEnum}}
\item{\code{$policyPeriod}}{Policy Duration (in years)}
\item{\code{$premiumPeriod}}{Premium payment period (in year), for
single-premium contracts, \code{premiumPeriod = 1}. Default is
\code{policyPeriod}, i.e. regular premiums during the whole
contract period}
\item{\code{$deferralPeriod}}{deferral period for annuities, i.e. the
period survival payments start only after this period, typically
the retirement age.  This applies mostly to tariffs of type
annuity, although deferral periods are possible (but not common)
for all other types of insurance, too.}
\item{\code{$guaranteedPeriod}}{guaranteed annuity payment period. The
annuity pays out for this period, even if the insured dies.
This applies only to tariffs of type annuity.}
\item{\code{$contractClosing}}{The date (variable of type \link{Date}) when
the coverage of the contract starts (not neccessarily equal to
the date when the contract was signed). Typically generated by
a call to \code{\link[=as.Date]{as.Date()}}. The year is relevant to derive the age
of the insured, while month and day are relevant for the
interpolation of the balance sheet reserves}
\item{\code{$blockStart}}{For contracts with multiple blocks (e.g.
multiple dynamic increases, where each increase is modelled
like a separate contract), this variable holds the offset of
the current contract block relative to the main contract block.
The main block starts a 0, dynamic increases start later! This
value is only used by the parent block (i.e. $t=0$ of the child
is aligned with $t=blockStart$ of the parent block.}
\item{\code{$premiumPayments}}{Whether premiums are paid in advance
(default) or arrears. Value is of type \link{PaymentTimeEnum}
with possible values "in advance" and 'in arrears"}
\item{\code{$benefitPayments}}{Whether recurring benefits (e.g. annuities)
are paid in advance (default) or arrears. Value is of type
\link{PaymentTimeEnum} with possible values "in advance" and
"in arrears"}
\item{\code{$premiumFrequency}}{Number of premium payments per year, default is 1.}
\item{\code{$benefitFrequency}}{Number of benefit payments per year, default is 1.}
\item{\code{$widowProportion}}{For annuities with a widow transition,
this describes the factor of the widow benefits relative to
the original benefit.}
\item{\code{$deathBenefitProportion}}{For endowments with a death and
survival benefit, this describes the proportion of the death
benefit relative to the survival benefit.}
\item{\code{$premiumRefund}}{Proportion of (gross) premiums refunded on
death (including additional risk, e.g. 1.10 = 110\% of paid premiums)}
\item{\code{$premiumIncrease}}{The yearly growth factor of the premium,
i.e. 1.05 means +5\% increase each year; a vector describes the
premiums for all years}
\item{\code{$annuityIncrease}}{The yearly growth factor of the annuity
payments, i.e. 1.05 means +5\% increase each year; a vector
describes the annuity unit payments for all years}
\item{\code{$deathBenefit}}{The yearly relative death benefit (relative
to the initial sum insured); Can be set to a \code{function(len,
              params, values)}, e.g. \code{deathBenefit = deathBenefit.linearDecreasing}}
}
}

\subsection{Elements of sublist \code{InsuranceContract.ParameterDefault$ContractState}}{

Contract-specific status variables holding the status of the contract.

\describe{
\item{\code{$premiumWaiver}}{Whether the contract is paid-up.}
\item{\code{$surrenderPenalty}}{Whether a surrender penalty still applies
(e.g. because it has already been applied during a contract change,
or because due to legal reasons it can no longer be applied)}
\item{\code{$alphaRefunded}}{Whether alpha costs have (at least partially)
been refunded (e.g. when a contract is changed or paid-up). Default
is not yet refunded.}
}
}

\subsection{Elements of sublist \code{InsuranceContract.ParameterDefault$ActuarialBases}}{

Tarif-specific actuarial calculation parameters of the contract. Typically,
these values are set by the tariff, but can be overridden by contract (e.g.
while prototyping a new product or a product change).

\describe{
\item{\code{$mortalityTable}}{The \link{mortalityTable} object describing the
mortality of the insured}
\item{\code{$invalidityTable}}{For contracts with invalidity benefits,
the \link{mortalityTable} object describing the probabilities of
invalidity}
\item{\code{$invalidityEndsContract}}{For contracts with invalidity
benefits, whether a payment of an invalidity benefit ends the
contract.}
\item{\code{$i}}{Guaranteed yearly interest rate, default is 0.00, i.e. 0\%}
\item{\code{$balanceSheetDate}}{The day/month when balance sheet reserves
are calculated. Value of type \link{Date}, typically generated with
\code{\link[=as.Date]{as.Date()}}. The year is actually irrelevant, only the day and
month are relevant.}
\item{\code{$balanceSheetMethod}}{How to interpolate the balance sheet
reserves (at the balandeSheetDate) from the yearly contractual
reserves.}
\item{\code{$surrenderValueCalculation}}{A function describing the surrender
value calculation.}
\item{\code{$premiumFrequencyOrder}}{Order of the approximation for
payments within the year (unless an extra frequency loading is
used => then leave this at 0)}
\item{\code{$benefitFrequencyOrder}}{Order of the approximation for
payments within the year (unless an extra frequency loading is
used => then leave this at 0)}
}
}

\subsection{Elements of sublist \code{InsuranceContract.ParameterDefault$Costs}}{

Definition of contractual costs charged to the contract. See \code{\link[=initializeCosts]{initializeCosts()}}.
}

\subsection{Elements of sublist \code{InsuranceContract.ParameterDefault$Loadings}}{

\describe{
\item{\code{$ongoingAlphaGrossPremium}}{Acquisition cost that increase the gross premium}
\item{\code{$tax}}{insurance tax, factor on each premium paid, default is 4\%, i.e. \code{i=0.04}}
\item{\code{$unitcosts}}{Annual unit cost for each policy, absolute value (can be a function)}
\item{\code{$security}}{Additional security loading on all benefit payments, factor on all benefits}
\item{\code{$noMedicalExam}}{Loading when no medicial exam is done, \% of SumInsured}
\item{\code{$noMedicalExamRelative}}{Loading when no medicial exam is done, \% of gross premium}
\item{\code{$sumRebate}}{gross premium reduction for large premiums, \% of SumInsured}
\item{\code{$extraRebate}}{gross premium reduction for any reason, \% of SumInsured}
\item{\code{$premiumRebate}}{gross premium reduction for large premiums, \% of gross premium}
\item{\code{$partnerRebate}}{Rebate on premium with all surcharges and
rebates when more than one contract is written with identical
parameters. Sums with advanceBonusInclUnitCost and premiumRebate.}
\item{\code{$extraChargeGrossPremium}}{extra charges on gross premium
(smoker, leisure activities, BMI too high, etc.)}
\item{\code{$benefitFrequencyLoading}}{Loading on the benefit for premium
payment frequencies of more than once a year. Format is
\code{list("1" = 0.0, "2" = 0.0, "4" = 0.0, "12" = 0.0)}}
\item{\code{$premiumFrequencyLoading}}{Loading on the premium for premium
payment frequencies of more than once a year. Format is
\code{list("1" = 0.0, "2" = 0.0, "4" = 0.0, "12" = 0.0)}}
\item{\code{$alphaRefundPeriod}}{How long the acquisition costs should be
(partially) refunded in case of surrender or premium waiver.}
}
}

\subsection{Elements of sublist \code{InsuranceContract.ParameterDefault$Features}}{

\describe{
\item{\code{$betaGammaInZillmer}}{Whether beta and gamma-costs should be
included in the Zillmer premium calculation}
\item{\code{$alphaRefundLinear}}{Whether the refund of alpha-costs on
surrender is linear in t or follows the NPV of an annuity}
}
}

\subsection{Elements of sublist \code{InsuranceContract.ParameterDefault$ProfitParticipation}}{

Parameters describing the profit participation (instance of \link{ProfitParticipation})
Most element descrive some kind of profit rate (which can vary in time),
while the bases, on which they are applied is defined in the profit scheme.

\describe{
\item{\code{$advanceProfitParticipation}}{Advance profit participation
rate (percentage rebate of the gross premium)}
\item{\code{$advanceProfitParticipationInclUnitCost}}{Advance profit
participation rate (percentage rebate on the gross premium after all surcharges and unit costs.}
\item{\code{$waitingPeriod}}{Waiting period of the profit sharing (e.g.
no profit in the first two years of a contract, or similar)}
\item{\code{$guaranteedInterest}}{Individual contract-specific overrides
of the guaranteed interest rate (i.e. not keyed by year)}
\item{\code{$interestProfitRate}}{Interest profit rate (guaranteed interest
rate + interest profit rate = total credited rate)}
\item{\code{$totalInterest}}{Total credited rate (guarantee + interest profit)}
\item{\code{$mortalityProfitRate}}{Mortality Profit rate}
\item{\code{$expenseProfitRate}}{Expense profit rate}
\item{\code{$sumProfitRate}}{Sum profit rate (for high sumInsured)}
\item{\code{$terminalBonusRate}}{Terminal bonus rate (non-terminal-bonus
fund, but "old" Austrian terminal bonus)}
\item{\code{$terminalBonusFundRate}}{Terminal bonus fund rate}
\item{\code{$profitParticipationScheme}}{Profit participation scheme (object of class \link{ProfitParticipation})}
\item{\code{$profitComponents}}{Profit components of the profit scheme. List containing one or more of \code{c("interest", "risk", "expense", "sum", "terminal")}}
\item{\code{$profitClass}}{String describing the profit class the tariff
is assigned to. Profit classes are used to bundle similar
contracts (e.g. following similar risks) together. Profit
participation rates are defined at the level of profit classes.}
\item{\code{$profitRates}}{General, company-wide profit rates, key columns are year and profitClass}\preformatted{\\item\{\code{$scenarios}\}\{profit participation scenarios (list of overridden parameters for each scenario)\}
}

}
}

\subsection{Elements of sublist \code{InsuranceContract.ParameterDefault$Hooks}}{

\describe{
\item{\code{$adjustCashFlows}}{Function with signature \code{function(x, params, values, ...)} to adjust the benefit/premium cash flows after their setup.}
\item{\code{$adjustCashFlowsCosts}}{Function with signature \code{function(x, params, values, ...)} to adjust the costs cash flows after their setup.}
}
}
}
\usage{
InsuranceContract.ParameterDefaults
}
\description{
Default parameters for the InsuranceContract class. A new contract will be
pre-filled with these values, and values passed in the constructor (or with
other setter functions) will override these values.
}
\examples{
InsuranceContract.ParameterDefaults
}
\keyword{datasets}
