% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LibOPF.R
\name{opf_cluster}
\alias{opf_cluster}
\title{Computes clusters by unsupervised OPF}
\usage{
opf_cluster(dataSet, kmax, calculateOp, value, precomputedDistance = NA)
}
\arguments{
\item{dataSet}{The training object produced by the opf_split function (subGraph object)}

\item{kmax}{The kmax (maximum degree for the knn graph)}

\item{calculateOp}{Clusters by: 0 for height, 1 for area and 2 for volume}

\item{value}{Value of parameter "calculateOp" in [0-1]}

\item{precomputedDistance}{The precomputed distance matrix produced by the opf_distance (leave it in blank if you are not using this resource)}
}
\value{
Returns a list which contains the classifier object and the classification list object (i.e., clusters' id)
}
\description{
Computes clusters by unsupervised OPF
}
\examples{
dat <- opf_read_subGraph(system.file("extdata/boat.dat",package = "LibOPF"))
X <- opf_split(dat,0.8,0,0.2,0)
T <- X$training
T2 <- X$testing
Y <- opf_cluster(T,100,1,0.2)
class <- opf_knn_classify(T2, Y$classifier)
acc <- opf_accuracy(T2, class)

}
