% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lexis.year.R
\name{lexis.year}
\alias{lexis.year}
\title{Emphasize a certain year in Lexis grid.}
\usage{
lexis.year(lg, year, fill = "blue", alpha = 0.5)
}
\arguments{
\item{lg, }{an existing object originally created with \code{lexis.grid()}.}

\item{year}{numeric, set the year to highlight.}

\item{fill}{character, set the colour of the rectangle. Default is \code{"blue"}.}

\item{alpha}{numeric, set the transparency of the rectangle. Default is \code{0.5}.}
}
\value{
A ggplot2 object.
}
\description{
Takes an existing Lexis grid and adds a coloured rectangle to highlight a certain age.
}
\details{
Takes an existing Lexis grid and adds a coloured rectangle to the plot. The rectangle will highlight a certain year in the grid.
}
\examples{
lg <- lexis.grid(year.start = 1900, year.end = 1905, age.start = 0, age.end = 5)
lexis.year(lg = lg, year = 1902)
}
\author{
Philipp Ottoliner
}

