% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_gamma_bounds.R
\name{get_gamma_bounds}
\alias{get_gamma_bounds}
\title{Get bounds for gamma}
\usage{
get_gamma_bounds(y, tau)
}
\arguments{
\item{y}{a numeric vector of real values (the observed data).}

\item{tau}{named vector \eqn{\tau} which defines the variable transformation.
Must have at least \code{'mu_x'} and \code{'sigma_x'} element; see
\code{\link{complete_tau}} for details.}
}
\value{
\code{get_gamma_bounds} returns a vector of length 2 with
    \code{"lower"} and \code{"upper"} bounds of \eqn{\gamma} given the range
    of \code{y}.
}
\description{
\code{get_gamma_bounds} returns lower and upper bounds for \eqn{\gamma}, so
that the observed data range falls within the theoretical bounds of the
support of the distribution. This is only important for location family
input.
}
\details{
Skewed Lambert W\eqn{\times} F distributions have
    parameter-dependent support for location family input.  Thus the
    parameter \eqn{\gamma} must be bounded such that the observed data is
    within the theoretical support of the distribution.  This theoretical
    bounds are determined by the Lambert W function (\code{\link{W}}), which
    has only real-valued solutions for \eqn{z \geq -1 / \exp(1)}.  Thus,
    \code{\link{W_gamma}} has real-valued solutions only for \eqn{z \geq -1 /
    \exp(1) \gamma} These lower and upper bounds are determined by minimum
    and maxiumum of the normalized data \eqn{\mathbf{z} = (\mathbf{y} -
    \mu_x) / \sigma_x}.
}
