% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/soil_to_param.R
\name{soil_to_param}
\alias{soil_to_param}
\title{Split up soil into materials and soil nodes.}
\usage{
soil_to_param(soil, imodel = "MvG")
}
\arguments{
\item{soil}{Data.frame with soil layer boundaries ('upper', 'lower') and
hydraulic parameters. When imodel = 'MvG', columns of soil have to be named 'ths', 'thr',
'alpha', 'npar', 'ksat', 'tort', 'gravel'. When imodel = 'CH', columns have to be named
thsat , 'thetaf','psif', 'bexp','kf', 'wetinf', 'gravel'.}

\item{imodel}{Name of the hydraulic model ('MvG' or 'CH')}
}
\value{
a list with data.frames 'soil_nodes' and 'soil_materials'
}
\description{
Split up soil into materials and soil nodes.
}
\examples{
data(slb1_soil)
soil <- slb1_soil
soil <- cbind(soil, hydpar_wessolek_tab(soil$texture))
str(soil)

soil_layers_materials <- soil_to_param(soil)
soil_layers_materials
}
