% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smr_custom.R
\name{smr_custom}
\alias{smr_custom}
\title{Calculate SMRs for Custom minor groupings}
\usage{
smr_custom(smr_minor_table, minor_grouping)
}
\arguments{
\item{smr_minor_table}{A data.frame/tibble as created by \code{smr_minor} containing
observed and expected number of deaths for each minor outcome}

\item{minor_grouping}{A numeric vector defining which minors to group together}
}
\value{
A data.frame/tibble containing the expected and observed number of deaths
as well the SMR, lower CI and upper CI for the outcome by the user
}
\description{
\code{smr_major} will collapse minor outcomes into "major" groupings as defined in the
rate object, \code{rateobj}.
}
\examples{
library(LTASR)
library(dplyr)

#Import example person file
person <- person_example \%>\%
  mutate(dob = as.Date(dob, format='\%m/\%d/\%Y'),
         pybegin = as.Date(pybegin, format='\%m/\%d/\%Y'),
         dlo = as.Date(dlo, format='\%m/\%d/\%Y'))

#Import default rate object
rateobj <- us_119ucod_19602021

#Stratify person table
py_table <- get_table(person, rateobj)

#Calculate SMRs for all minors
smr_minor_table <- smr_minor(py_table, rateobj)

#Calculate custom minor grouping for all deaths
smr_custom(smr_minor_table, 1:119)

#' #Calculate custom minor grouping for all deaths
smr_custom(smr_minor_table, 4:40)

}
