% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.textmodel.R
\name{as.textmodel_lss}
\alias{as.textmodel_lss}
\title{Create a Latent Semantic Scaling model from various objects}
\usage{
as.textmodel_lss(x, ...)
}
\arguments{
\item{x}{an object from which a new \link{textmodel_lss} object is created. See details.}

\item{...}{arguments used to create a new object. \code{seeds} must be given
when \code{x} is a dense matrix or a fitted textmodel_lss.}
}
\value{
a dummy \link{textmodel_lss} object
}
\description{
Create a new \link{textmodel_lss} object from an existing or foreign objects.
}
\details{
If \code{x} is a \link{textmodel_lss}, original word vectors are reused to compute polarity
scores with new seed words. It is also possible to subset word vectors via \code{slice}
if it was trained originally using SVD.

If \code{x} is a dense matrix, it is treated as a column-oriented word vectors with which
polarity of words are computed. If \code{x} is a named numeric vector, the values are treated
as polarity scores of the words in the names.

If \code{x} is a normalized \link[wordvector:textmodel_word2vec]{wordvector::textmodel_word2vec}, it returns a spatial model;
if not normalized, a probabilistic model. While the polarity scores of words are
their cosine similarity to seed words in spatial models, they are
predicted probability that the seed words to occur in their proximity.
}
