% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_input.R
\name{img2ps}
\alias{img2ps}
\title{img2ps}
\usage{
img2ps(img = NULL, bkg = 0, crop.size = NULL)
}
\arguments{
\item{img}{either a 2d or 3d array or a path to a file containing a 2d or 3d image.}

\item{bkg}{Extract points for values strictly above this (default = 0).}

\item{crop.size}{vector (of length 2 or 3) containing the desired reduced size of the images along each dimension, e.g. c(30,30,30).}
}
\value{
a point set as matrix with columns x,y[,z]
}
\description{
Read an image into a point set. 
The points are formed by extracting the coordinates of voxel values strictly above the given cut-off (default 0).
}
\examples{
img.file <- system.file("test_data/img", "alien1_3d.tif", package = "LOMAR",
 mustWork = TRUE) 
point_set <- img2ps(img = img.file, bkg = 0)
}
