% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sigma.R
\name{sigma}
\alias{sigma}
\alias{sigma.lmm}
\title{Extract The Residuals Variance-Covariance Matrix From a Linear Mixed Model}
\usage{
\method{sigma}{lmm}(
  object,
  cluster = NULL,
  p = NULL,
  inverse = FALSE,
  simplifies = TRUE,
  ...
)
}
\arguments{
\item{object}{a \code{lmm} object.}

\item{cluster}{[character, data.frame, NULL] identifier of the cluster(s) for which to extract the residual variance-covariance matrix.
For new clusters, a dataset containing the information (cluster, time, strata, ...) to be used to generate the residual variance-covariance matrices.
When \code{NULL}, will output complete data covariance patterns.}

\item{p}{[numeric vector] value of the model coefficients at which to evaluate the residual variance-covariance matrix. Only relevant if differs from the fitted values.}

\item{inverse}{[logical] Output the matrix inverse of the variance-covariance matrix.}

\item{simplifies}{[logical] When there is only one variance-covariance matrix, output a matrix instead of a list of matrices.}

\item{...}{Not used. For compatibility with the generic method.}
}
\value{
A list where each element contains a residual variance-covariance matrix.
Can also be directly a matrix when argument is \code{simplifies=TRUE} and there is a single residual variance-covariance matrix.
}
\description{
Extract the unique set of residuals variance-covariance matrices or the one relative to specific clusters.
}
\examples{
## simulate data in the long format
set.seed(10)
dL <- sampleRem(100, n.times = 3, format = "long")
dL$id.fac <- paste0("id",dL$id)

## fit Linear Mixed Model
eUN.lmm <- lmm(Y ~ X1 + X2 + X5, repetition = ~visit|id.fac,
               structure = "UN", data = dL, df = FALSE)

## extract residuals variance covariance matrix
sigma(eUN.lmm) ## unique patterns
sigma(eUN.lmm, cluster = c("id1","id5")) ## existing clusters
sigma(eUN.lmm, cluster = dL[1:7,,drop=FALSE]) ## new clusters
}
