% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot}
\alias{plot}
\alias{plot.lmm}
\title{Graphical Display For Linear Mixed Models}
\usage{
\method{plot}{lmm}(
  x,
  type = "fit",
  type.residual = "normalized",
  by.time = TRUE,
  ci = TRUE,
  plot = TRUE,
  ci.alpha = 0.2,
  mean.size = c(3, 1),
  size.text = 16,
  ...
)
}
\arguments{
\item{x}{a \code{lmm} object.}

\item{type}{[character] the type of plot: \code{"fit"}, \code{"qqplot"}, \code{"correlation"}, \code{"scatterplot"}, \code{"scatterplot2"}, \code{"partial"}.}

\item{type.residual}{[character] the type of residual to be used. Not relevant for \code{type="fit"}.
By default, normalized residuals are used except when requesting a partial residual plot.}

\item{by.time}{[logical] should a separate plot be made at each repetition or a single plot over all repetitions be used?
Only relevant for \code{type="qqplot"}, \code{type="scatterplot"}, and \code{type="scatterplot2"}.}

\item{ci}{[logical] should confidence intervals be displayed?}

\item{plot}{[logical] should the plot be displayed?}

\item{ci.alpha}{[numeric, 0-1] Transparency parameter used to display the confidence intervals.}

\item{mean.size}{[numeric vector of length 2] size of the point and line for the mean trajectory.}

\item{size.text}{[numeric, >0] size of the font used to displayed text when using ggplot2.}

\item{...}{additional argument passed to \code{residuals.lmm} or \code{autoplot.lmm}.}
}
\value{
A list with two elements \itemize{
\item \code{data}: data used to create the graphical display.
\item \code{plot}: ggplot object.
}
}
\description{
Display fitted values or residual plot for the mean, variance, and correlation structure.
Can also display quantile-quantile plot relative to the normal distribution.
}
\details{
Call \code{\link{autoplot.lmm}} when code{type=="fit"} and \code{link(residuals.lmm)} for the other types.
}
